/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BlankScrollItem
extends Item
implements IWorkbenchItem {
    public BlankScrollItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onApplyButtonPressed(Player player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        if (spellBooks[0].m_7993_().m_41619_() || crystals.m_7993_().m_41619_()) {
            return false;
        }
        Spell spell = SpellUtil.getSpell(spellBooks[0].m_7993_());
        if (!this.canPlayerUseSpell(player, spell)) {
            return false;
        }
        int scrollCost = this.calculateScrollCost(spell, centre.m_7993_().m_41613_());
        int manaPerCrystal = this.getManaPerCrystal(crystals.m_7993_());
        if (this.hasEnoughMana(crystals.m_7993_().m_41613_(), manaPerCrystal, scrollCost)) {
            this.consumeCrystalsAndCreateScroll(crystals, centre, spell, scrollCost, manaPerCrystal);
            return true;
        }
        return false;
    }

    private boolean canPlayerUseSpell(Player player, Spell spell) {
        if (spell == Spells.NONE) {
            return false;
        }
        if (!spell.isEnabled(SpellContext.SCROLL)) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
        return data != null && data.hasSpellBeenDiscovered(spell);
    }

    private int calculateScrollCost(Spell spell, int scrollCount) {
        int cost = spell.getProperties().getCost() * scrollCount;
        if (!spell.isInstantCast()) {
            cost *= 6;
        }
        return cost;
    }

    private int getManaPerCrystal(ItemStack crystalStack) {
        Item crystal = crystalStack.m_41720_();
        if (crystal == EBItems.MAGIC_CRYSTAL_SHARD.get()) {
            return 10;
        }
        if (crystal == EBItems.MAGIC_CRYSTAL_GRAND.get()) {
            return 400;
        }
        return 100;
    }

    private boolean hasEnoughMana(int crystalCount, int manaPerCrystal, int requiredMana) {
        return crystalCount * manaPerCrystal > requiredMana;
    }

    private void consumeCrystalsAndCreateScroll(Slot crystals, Slot centre, Spell spell, int cost, int manaPerCrystal) {
        crystals.m_6201_(Mth.m_14167_((float)((float)cost / (float)manaPerCrystal)));
        ItemStack scroll = SpellUtil.setSpell(EBItems.SCROLL.get().m_7968_(), spell);
        scroll.m_41764_(centre.m_7993_().m_41613_());
        centre.m_5852_(scroll);
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return false;
    }
}

