/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Spells;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class RandomSpellBookItem
extends Item {
    public RandomSpellBookItem(Item.Properties properties) {
        super(properties);
    }

    public static void create(Level level, Player player, ItemStack original) {
        if (level.f_46443_) {
            return;
        }
        CompoundTag tag = original.m_41783_();
        if (tag == null || !tag.m_128441_("LootTable")) {
            ItemStack stack = SpellUtil.setSpell(new ItemStack((ItemLike)EBItems.SPELL_BOOK.get()), Spells.MAGIC_MISSILE);
            RandomSpellBookItem.spawn(level, player.m_20183_(), stack);
            EBLogger.error("Attempted to use a RandomSpellBookItem without a LootTable NBT tag.", new Object[0]);
            return;
        }
        String lootTableId = tag.m_128461_("LootTable");
        ResourceLocation lootTableLocation = ResourceLocation.m_135820_((String)lootTableId);
        if (lootTableLocation == null) {
            ItemStack stack = SpellUtil.setSpell(new ItemStack((ItemLike)EBItems.SPELL_BOOK.get()), Spells.MAGIC_MISSILE);
            RandomSpellBookItem.spawn(level, player.m_20183_(), stack);
            EBLogger.error("Attempted to use a RandomSpellBookItem with an invalid LootTable NBT tag.", new Object[0]);
            return;
        }
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableLocation);
        LootParams lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_);
        ObjectArrayList loot = lootTable.m_287195_(lootParams);
        loot.forEach(i -> RandomSpellBookItem.spawn(level, player.m_20183_(), i));
        original.m_41774_(1);
    }

    private static void spawn(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        level.m_7967_((Entity)itemEntity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        RandomSpellBookItem.create(level, player, stack);
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

