/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.CastUtils;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.networking.s2c.SpellCastS2C;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollItem
extends Item
implements ISpellCastingItem,
IWorkbenchItem {
    public static final int CASTING_TIME = 120;
    public static final int COOLDOWN_FORFEIT_TICKS = 60;

    public ScrollItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Spell spell = this.getCurrentSpell(stack);
        if (spell == Spells.NONE) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        PlayerCastContext ctx = new PlayerCastContext(level, player, hand, 0, new SpellModifiers());
        if (!this.canCast(stack, spell, ctx)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!spell.isInstantCast()) {
            player.m_6672_(hand);
            Services.OBJECT_DATA.getWizardData(player).setSpellModifiers(ctx.modifiers());
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (this.cast(stack, spell, ctx)) {
            if (!level.f_46443_ && spell.requiresPacket()) {
                Services.NETWORK_HELPER.sendToDimension(level.m_7654_(), new SpellCastS2C(player.m_19879_(), hand, spell, ctx.modifiers()), (ResourceKey<Level>)level.m_46472_());
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int timeLeft) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Spell spell = SpellUtil.getSpell(stack);
        int castingTick = stack.m_41779_() - timeLeft;
        PlayerCastContext ctx = new PlayerCastContext(level, player, player.m_7655_(), castingTick, Services.OBJECT_DATA.getWizardData(player).getSpellModifiers());
        if (!spell.isInstantCast() && this.canCast(stack, spell, ctx)) {
            spell.cast(ctx);
        } else {
            livingEntity.m_5810_();
        }
    }

    @Override
    public boolean canCast(ItemStack stack, Spell spell, PlayerCastContext ctx) {
        if (CastUtils.fireSpellCastEvent(SpellCastEvent.Source.SCROLL, spell, ctx)) {
            CastUtils.applyCooldownForfeit(ctx.caster(), 60);
            return false;
        }
        return true;
    }

    @Override
    public boolean cast(ItemStack stack, Spell spell, PlayerCastContext ctx) {
        if (!CastUtils.executeSpellCast(SpellCastEvent.Source.SCROLL, spell, ctx)) {
            return false;
        }
        if (spell.isInstantCast() && !ctx.caster().m_7500_()) {
            stack.m_41774_(1);
            ctx.caster().m_36335_().m_41524_((Item)this, spell.getCooldown());
        }
        CastUtils.trackSpellUsage(ctx.caster(), spell);
        return true;
    }

    private void finishCast(ItemStack stack, Level world, LivingEntity entity, int timeCharged) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Spell spell = SpellUtil.getSpell(stack);
        if (spell.isInstantCast()) {
            return;
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
            player.m_36335_().m_41524_((Item)this, spell.getCooldown());
        }
        int castingTick = stack.m_41779_() - timeCharged;
        SpellModifiers modifiers = new SpellModifiers();
        WizardryEventBus.getInstance().fire(new SpellCastEvent.Finish(SpellCastEvent.Source.SCROLL, spell, entity, modifiers, castingTick));
        spell.endCast(new CastContext(world, entity, castingTick, modifiers));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        if (level == null) {
            return;
        }
        Spell spell = SpellUtil.getSpell(stack);
        if (ClientUtils.shouldDisplayDiscovered(spell, stack) && tooltipFlag.m_7050_()) {
            list.add((Component)Component.m_237115_((String)spell.getTier().getDescriptionId()).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)spell.getElement().getDescriptionId()).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)spell.getType().getUnlocalisedName()).m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        this.finishCast(stack, level, livingEntity, 0);
        return super.m_5922_(stack, level, livingEntity);
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        this.finishCast(stack, level, livingEntity, timeCharged);
    }

    @Override
    @NotNull
    public Spell getCurrentSpell(ItemStack stack) {
        return SpellUtil.getSpell(stack);
    }

    @Override
    public boolean showSpellHUD(Player player, ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return ClientUtils.getScrollDisplayName(stack);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 120;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onApplyButtonPressed(Player player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        return false;
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean canPlace(ItemStack stack) {
        return false;
    }
}

