/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.setup.registries.Spells;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellBookItem
extends Item {
    public SpellBookItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (SpellUtil.getSpell(stack) == Spells.NONE) {
            SpellUtil.setSpell(stack, Spells.MAGIC_MISSILE);
            EBLogger.warn("SpellBookItem has no spell assigned to it! Defaulting to Magic Missile, where did this item come from?", new Object[0]);
        }
        if (level.f_46443_) {
            ClientUtils.openSpellBook(stack);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public void m_7836_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player) {
        super.m_7836_(stack, level, player);
        Spell spell = SpellUtil.getSpell(stack);
        if (spell == Spells.NONE) {
            SpellUtil.setSpell(stack, Spells.MAGIC_MISSILE);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return ClientUtils.getBookDisplayName(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        if (level == null) {
            return;
        }
        Spell spell = SpellUtil.getSpell(stack);
        if (spell == Spells.NONE) {
            return;
        }
        boolean discovered = ClientUtils.shouldDisplayDiscovered(spell, stack);
        list.add(spell.getTier().getDescriptionFormatted());
        if (discovered && tooltipFlag.m_7050_()) {
            list.add((Component)Component.m_237115_((String)spell.getElement().getDescriptionId()).m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)spell.getType().getDisplayName()).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public ResourceLocation getGuiTexture(Spell spell) {
        ResourceLocation l = spell.getTier().getOrCreateLocation();
        return new ResourceLocation(l.m_135827_(), "textures/gui/spell_book_" + l.m_135815_() + ".png");
    }
}

