/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.data.WizardData;
import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.ISpellCastingItem;
import com.binaris.wizardry.api.content.item.ITierValue;
import com.binaris.wizardry.api.content.item.IWizardryItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.CastUtils;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WandHelper;
import com.binaris.wizardry.api.content.util.WorkbenchUtils;
import com.binaris.wizardry.content.item.ArcaneTomeItem;
import com.binaris.wizardry.core.ClientSpellSoundManager;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WandItem
extends Item
implements ISpellCastingItem,
IManaStoringItem,
IWorkbenchItem,
IWizardryItem,
ITierValue,
IElementValue {
    public static final int BASE_SPELL_SLOTS = 5;
    public static final int COOLDOWN_FORFEIT_TICKS = 60;
    public static final int MAX_USE_DURATION = 72000;
    private final SpellTier tier;
    private final Element element;

    public WandItem(SpellTier tier, Element element) {
        super(new Item.Properties().m_41487_(1).m_41503_(tier.maxCharge));
        this.tier = tier;
        this.element = element;
    }

    protected static int getAccumulatedCost(Spell spell, int castingTick, int totalCost) {
        int accumulatedCost = 0;
        if (!spell.isInstantCast() && castingTick > 0) {
            int completeCycles = castingTick / 20;
            int remainingTicks = castingTick % 20;
            accumulatedCost = completeCycles * totalCost;
            if (remainingTicks > 0) {
                accumulatedCost += totalCost / 2 + totalCost % 2;
                if (remainingTicks >= 10) {
                    accumulatedCost += totalCost / 2;
                }
            }
        }
        return accumulatedCost;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Spell spell = WandHelper.getCurrentSpell(stack);
        if (spell == Spells.NONE) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        PlayerCastContext ctx = this.createContext(level, player, hand, 0, stack, spell);
        if (!this.canCastRequirements(stack, spell, ctx)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int charge = this.calculateCharge(spell, ctx);
        if (!this.requiresCharging(spell, charge)) {
            if (this.canCast(stack, spell, ctx)) {
                if (!level.f_46443_) {
                    this.consumeManaAndSetCooldown(stack, spell, player, ctx.modifiers());
                }
                if (this.cast(stack, spell, ctx)) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return this.startCharging(level, player, hand, stack, charge, ctx);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity user, @NotNull ItemStack stack, int timeLeft) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        Spell spell = WandHelper.getCurrentSpell(stack);
        SpellModifiers modifiers = Services.OBJECT_DATA.getWizardData(player).getSpellModifiers();
        int useTick = stack.m_41779_() - timeLeft;
        int charge = this.calculateCharge(spell, modifiers);
        int castingTick = spell.isInstantCast() ? (useTick == charge ? 0 : -1) : Math.max(0, useTick - charge);
        PlayerCastContext ctx = this.createContext(level, player, user.m_7655_(), castingTick, stack, spell);
        if (spell.isInstantCast()) {
            this.handleInstantSpellTick(ctx, spell, stack, useTick, charge);
        } else {
            this.handleContinuousSpellTick(ctx, spell, stack, useTick, charge);
        }
    }

    @Override
    public boolean canCast(ItemStack stack, Spell spell, PlayerCastContext ctx) {
        if (CastUtils.fireSpellCastEvent(SpellCastEvent.Source.WAND, spell, ctx)) {
            CastUtils.applyCooldownForfeit(ctx.caster(), 60);
            return false;
        }
        return this.canCastRequirements(stack, spell, ctx);
    }

    private boolean canCastRequirements(ItemStack stack, Spell spell, PlayerCastContext ctx) {
        int cost = (int)((float)spell.getCost() * ctx.modifiers().get("cost") + 0.1f);
        if (!spell.isInstantCast()) {
            cost = WandHelper.getDistributedCost(cost, ctx.castingTicks());
        }
        return cost <= this.getMana(stack) && spell.getTier().level <= this.tier.level && (WandHelper.getCurrentCooldown(stack, ctx.world().m_46467_()) == 0 || ctx.caster().m_7500_());
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        if (this.tier == SpellTiers.MASTER) {
            return false;
        }
        return WandHelper.getProgression(stack) >= this.tier.getProgression();
    }

    @Override
    public boolean cast(ItemStack stack, Spell spell, PlayerCastContext ctx) {
        if (ctx.world().f_46443_ && spell.isInstantCast() && spell.requiresPacket()) {
            return false;
        }
        if (!CastUtils.executeSpellCast(SpellCastEvent.Source.WAND, spell, ctx)) {
            return false;
        }
        CastUtils.sendSpellCastPacket(ctx.caster(), spell, ctx);
        if (!spell.isInstantCast()) {
            ctx.caster().m_6672_(ctx.hand());
        }
        this.handleProgression(ctx, spell, stack);
        CastUtils.trackSpellUsage(ctx.caster(), spell);
        return true;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (player.m_6047_() && interactionTarget instanceof Player) {
            String string;
            Player playerTarget = (Player)interactionTarget;
            WizardData data = Services.OBJECT_DATA.getWizardData(player);
            String string2 = string = data.toggleAlly(playerTarget) ? "item.ebwizardry.wand.add_ally" : "item.ebwizardry.wand.remove_ally";
            if (!player.m_9236_().f_46443_) {
                player.m_213846_((Component)Component.m_237110_((String)string, (Object[])new Object[]{playerTarget.m_7755_()}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Spell spell = WandHelper.getCurrentSpell(stack);
        WizardData wizardData = Services.OBJECT_DATA.getWizardData(player);
        SpellModifiers modifiers = wizardData.getSpellModifiers();
        int castingTick = stack.m_41779_() - timeCharged;
        int totalCost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        int accumulatedCost = WandItem.getAccumulatedCost(spell, castingTick, totalCost);
        if (!spell.isInstantCast() && spell.getTier().level <= this.tier.level) {
            WizardryEventBus.getInstance().fire(new SpellCastEvent.Finish(SpellCastEvent.Source.WAND, spell, livingEntity, modifiers, castingTick));
            spell.endCast(new CastContext(player.m_9236_(), (LivingEntity)player, castingTick, modifiers));
            if (!level.f_46443_) {
                this.consumeMana(stack, accumulatedCost, (LivingEntity)player);
                if (!player.m_7500_()) {
                    WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(EBItems.COOLDOWN_UPGRADE.get())), level.m_46467_());
                }
            }
        }
    }

    @Override
    public boolean onApplyButtonPressed(Player player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (upgrade.m_6657_()) {
            changed = this.applyUpgradeSlot(player, centre, upgrade);
        }
        changed |= WorkbenchUtils.applySpellBooks(centre, spellBooks, SpellContext.WANDS);
        return changed |= WorkbenchUtils.rechargeManaFromCrystals(centre, crystals);
    }

    @Override
    public ItemStack applyUpgrade(@Nullable Player player, ItemStack wand, ItemStack upgrade) {
        if (upgrade.m_41720_() == EBItems.ARCANE_TOME.get()) {
            return this.applyTierUpgrade(player, wand, upgrade);
        }
        if (WandUpgrades.isWandUpgrade(upgrade.m_41720_())) {
            this.applySpecialUpgrade(player, wand, upgrade);
        }
        return wand;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean isHeldInMainhand) {
        if (!world.f_46443_ && !this.isManaFull(stack) && world.m_46467_() % 50L == 0L) {
            this.rechargeMana(stack, WandHelper.getUpgradeLevel(stack, EBItems.CONDENSER_UPGRADE.get()));
        }
    }

    @Override
    public void onClearButtonPressed(Player player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        ItemStack stack = centre.m_7993_();
        if (!stack.m_41784_().m_128441_("spells")) {
            return;
        }
        List<Spell> spells = WandHelper.getSpells(stack);
        int expectedSlotCount = 5 + WandHelper.getUpgradeLevel(stack, EBItems.ATTUNEMENT_UPGRADE.get());
        if (spells.size() < expectedSlotCount) {
            spells = new ArrayList<Spell>();
        }
        WandHelper.setSpells(stack, spells);
    }

    protected void handleInstantSpellTick(PlayerCastContext ctx, Spell spell, ItemStack stack, int useTick, int charge) {
        if (useTick != charge) {
            return;
        }
        if (this.canCast(stack, spell, ctx)) {
            if (!ctx.world().f_46443_) {
                this.consumeManaAndSetCooldown(stack, spell, ctx.caster(), ctx.modifiers());
            }
            this.cast(stack, spell, ctx);
        }
        ctx.caster().m_5810_();
    }

    private void handleContinuousSpellTick(PlayerCastContext ctx, Spell spell, ItemStack stack, int useTick, int charge) {
        if (useTick < charge) {
            return;
        }
        if (this.canCast(stack, spell, ctx)) {
            this.cast(stack, spell, ctx);
        } else {
            ctx.caster().m_5810_();
        }
    }

    private InteractionResultHolder<ItemStack> startCharging(Level level, Player player, InteractionHand hand, ItemStack stack, int charge, PlayerCastContext ctx) {
        if (!player.m_6117_()) {
            player.m_6672_(hand);
            Services.OBJECT_DATA.getWizardData(player).setSpellModifiers(ctx.modifiers());
            if (charge > 0 && level.f_46443_) {
                ClientSpellSoundManager.playChargeSound((LivingEntity)player);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    protected PlayerCastContext createContext(Level level, Player player, InteractionHand hand, int tick, ItemStack stack, Spell spell) {
        SpellModifiers modifiers = tick == 0 ? WandHelper.calculateModifiers(stack, player, spell) : Services.OBJECT_DATA.getWizardData(player).getSpellModifiers();
        return new PlayerCastContext(level, player, hand, tick, modifiers);
    }

    protected int calculateCharge(Spell spell, PlayerCastContext ctx) {
        return this.calculateCharge(spell, ctx.modifiers());
    }

    private int calculateCharge(Spell spell, SpellModifiers modifiers) {
        return (int)((float)spell.getCharge() * modifiers.get("chargeup"));
    }

    private void consumeManaAndSetCooldown(ItemStack stack, Spell spell, Player player, SpellModifiers modifiers) {
        int cost = this.calculateSpellCost(spell, modifiers);
        this.consumeMana(stack, cost, (LivingEntity)player);
        if (!player.m_7500_()) {
            WandHelper.setCurrentCooldown(stack, (int)((float)spell.getCooldown() * modifiers.get(EBItems.COOLDOWN_UPGRADE.get())), player.m_9236_().m_46467_());
        }
    }

    private int calculateSpellCost(Spell spell, SpellModifiers modifiers) {
        return (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
    }

    private boolean requiresCharging(Spell spell, int charge) {
        return !spell.isInstantCast() || charge > 0;
    }

    protected boolean applyUpgradeSlot(Player player, Slot centre, Slot upgrade) {
        ItemStack original = centre.m_7993_().m_41777_();
        centre.m_5852_(this.applyUpgrade(player, centre.m_7993_(), upgrade.m_7993_()));
        return !ItemStack.m_41656_((ItemStack)centre.m_7993_(), (ItemStack)original);
    }

    protected ItemStack applyTierUpgrade(@Nullable Player player, ItemStack wand, ItemStack tomeStack) {
        if (this.tier == SpellTiers.MASTER) {
            return wand;
        }
        Item item = tomeStack.m_41720_();
        if (!(item instanceof ArcaneTomeItem)) {
            return wand;
        }
        ArcaneTomeItem tomeItem = (ArcaneTomeItem)item;
        SpellTier nextTier = tomeItem.getTier(tomeStack);
        if (this.tier == nextTier) {
            return wand;
        }
        if (player == null || WandHelper.getProgression(wand) >= nextTier.getProgression()) {
            int newProgression = Math.max(0, WandHelper.getProgression(wand) - nextTier.getProgression());
            WandHelper.setProgression(wand, newProgression);
            if (player != null) {
                Services.OBJECT_DATA.getWizardData(player).setTierReached(this.tier);
            }
            ItemStack newWand = new ItemStack((ItemLike)RegistryUtils.getWand(nextTier, this.element));
            newWand.m_41751_(wand.m_41783_());
            ((IManaStoringItem)newWand.m_41720_()).setMana(newWand, this.getMana(wand));
            tomeStack.m_41774_(1);
            return newWand;
        }
        return wand;
    }

    protected void applySpecialUpgrade(@Nullable Player player, ItemStack wand, ItemStack upgrade) {
        Item specialUpgrade = upgrade.m_41720_();
        int maxUpgrades = this.tier.upgradeLimit + (this.element == Elements.MAGIC ? 3 : 0);
        if (WandHelper.getTotalUpgrades(wand) >= maxUpgrades || WandHelper.getUpgradeLevel(wand, specialUpgrade) >= 3) {
            return;
        }
        int prevMana = this.getMana(wand);
        WandHelper.applyUpgrade(wand, specialUpgrade);
        if (specialUpgrade == EBItems.STORAGE_UPGRADE.get()) {
            this.setMana(wand, prevMana);
        } else if (specialUpgrade == EBItems.ATTUNEMENT_UPGRADE.get()) {
            this.expandSpellSlots(wand);
        }
        upgrade.m_41774_(1);
        if (player == null) {
            return;
        }
        EBAdvancementTriggers.SPECIAL_UPGRADE.triggerFor(player);
        if (WandHelper.getTotalUpgrades(wand) == SpellTiers.MASTER.upgradeLimit) {
            EBAdvancementTriggers.MAX_OUT_WAND.triggerFor(player);
        }
    }

    protected void expandSpellSlots(ItemStack wand) {
        int newSlotCount = 5 + WandHelper.getUpgradeLevel(wand, EBItems.ATTUNEMENT_UPGRADE.get());
        List<Spell> spells = WandHelper.getSpells(wand);
        Spell[] newSpells = new Spell[newSlotCount];
        for (int i = 0; i < newSpells.length; ++i) {
            newSpells[i] = i < spells.size() && spells.get(i) != null ? spells.get(i) : Spells.NONE;
        }
        WandHelper.setSpells(wand, List.of(newSpells));
    }

    protected void handleProgression(PlayerCastContext ctx, Spell spell, ItemStack stack) {
        boolean shouldAddProgression;
        if (this.tier.level >= SpellTiers.MASTER.level) {
            return;
        }
        boolean bl = spell.isInstantCast() ? ctx.castingTicks() == 0 : (shouldAddProgression = ctx.castingTicks() % 20 == 0);
        if (!shouldAddProgression) {
            return;
        }
        int progression = (int)((float)spell.getCost() * ctx.modifiers().get("progression"));
        WandHelper.addProgression(stack, progression);
        this.checkLevelUp(ctx, stack, progression);
    }

    protected void checkLevelUp(PlayerCastContext ctx, ItemStack stack, int progression) {
        Player player = ctx.caster();
        SpellTier nextTier = this.tier.next();
        int excess = WandHelper.getProgression(stack) - nextTier.getProgression();
        if (excess >= 0 && excess < progression) {
            player.m_5496_(EBSounds.ITEM_WAND_LEVELUP.get(), 1.25f, 1.0f);
            if (!player.m_9236_().f_46443_) {
                player.m_213846_((Component)Component.m_237110_((String)"item.ebwizardry.wand.levelup", (Object[])new Object[]{this.m_7626_(stack), nextTier.getDescriptionFormatted()}));
            }
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return this.element == null ? super.m_7626_(stack) : Component.m_237113_((String)super.m_7626_(stack).getString()).m_130940_(this.element.getColor());
    }

    @Override
    public void selectNextSpell(ItemStack stack) {
        Spell nextSpell = WandHelper.getNextSpell(stack);
        WandHelper.setCurrentSpell(stack, nextSpell);
    }

    @Override
    public void selectPreviousSpell(ItemStack stack) {
        Spell previousSpell = WandHelper.getPreviousSpell(stack);
        WandHelper.setCurrentSpell(stack, previousSpell);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return (int)((float)this.m_41462_() * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel(stack, EBItems.STORAGE_UPGRADE.get())) + 0.5f);
    }

    @Override
    public void setDamage(ItemStack stack, int damage) {
        stack.m_41784_().m_128405_("Damage", Math.max(0, Math.min(damage, stack.m_41776_())));
    }

    public int m_142159_(ItemStack stack) {
        return DrawingUtils.mix(16747518, 9318116, stack.m_41773_());
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @Override
    public boolean isClearable() {
        return true;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    @Override
    public boolean selectSpell(ItemStack stack, int index) {
        return WandHelper.selectSpell(stack, index);
    }

    @Override
    public int getCurrentCooldown(ItemStack stack, Level level) {
        return WandHelper.getCurrentCooldown(stack, level.m_46467_());
    }

    @Override
    public int getCurrentMaxCooldown(ItemStack stack) {
        return WandHelper.getCurrentMaxCooldown(stack);
    }

    @Override
    public boolean showSpellHUD(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - stack.m_41773_();
    }

    @Override
    public int getManaCapacity(ItemStack stack) {
        return stack.m_41776_();
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        stack.m_41721_(this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 5 + WandHelper.getUpgradeLevel(stack, EBItems.ATTUNEMENT_UPGRADE.get());
    }

    @Override
    @NotNull
    public Spell getCurrentSpell(ItemStack stack) {
        return WandHelper.getCurrentSpell(stack);
    }

    @Override
    @NotNull
    public Spell getNextSpell(ItemStack stack) {
        return WandHelper.getNextSpell(stack);
    }

    @Override
    @NotNull
    public Spell getPreviousSpell(ItemStack stack) {
        return WandHelper.getPreviousSpell(stack);
    }

    @Override
    public Spell[] getSpells(ItemStack stack) {
        return WandHelper.getSpells(stack).toArray(new Spell[0]);
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean validForReceptacle() {
        return false;
    }

    @Override
    public SpellTier getTier(ItemStack stack) {
        return this.tier;
    }
}

