/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.event.SpellCastEvent;
import com.binaris.wizardry.api.content.item.IElementValue;
import com.binaris.wizardry.api.content.item.IManaStoringItem;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.api.content.util.RegistryUtils;
import com.binaris.wizardry.api.content.util.WorkbenchUtils;
import com.binaris.wizardry.content.item.WizardArmorType;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardArmorItem
extends ArmorItem
implements IManaStoringItem,
IWorkbenchItem,
IElementValue {
    private static final float SAGE_OTHER_COST_REDUCTION = 0.2f;
    private static final float WARLOCK_SPEED_BOOST = 0.2f;
    private final Element element;
    private final WizardArmorType wizardArmorType;

    public WizardArmorItem(WizardArmorType material, ArmorItem.Type type, Element element) {
        super((ArmorMaterial)material, type, new Item.Properties());
        this.wizardArmorType = material;
        this.element = element;
    }

    public static void onSpellPreCast(SpellCastEvent.Pre event) {
        LivingEntity livingEntity;
        if (event.getCaster() == null || !((livingEntity = event.getCaster()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SpellModifiers armourModifiers = new SpellModifiers();
        WizardArmorItem.collectArmorModifiers(player, event.getSpell(), armourModifiers);
        event.getModifiers().combine(armourModifiers);
    }

    public static void onSpellTickCast(SpellCastEvent.Tick event) {
        LivingEntity livingEntity;
        if (event.getCaster() == null || !((livingEntity = event.getCaster()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SpellModifiers armourModifiers = new SpellModifiers();
        WizardArmorItem.collectArmorModifiers(player, event.getSpell(), armourModifiers);
        event.getModifiers().combine(armourModifiers);
    }

    private static void collectArmorModifiers(Player caster, Spell spell, SpellModifiers out) {
        Arrays.stream(InventoryUtil.ARMOR_SLOTS).map(slot -> caster.m_6844_(slot).m_41720_()).filter(i -> i instanceof WizardArmorItem).forEach(i -> ((WizardArmorItem)i).applySpellModifiers((LivingEntity)caster, spell, out));
    }

    @Override
    public ItemStack applyUpgrade(@Nullable Player player, ItemStack stack, ItemStack upgrade) {
        if (this.wizardArmorType != WizardArmorType.WIZARD) {
            return stack;
        }
        for (WizardArmorType armourClass : WizardArmorType.values()) {
            if (upgrade.m_41720_() != armourClass.upgradeItem.get()) continue;
            Item newItem = RegistryUtils.getArmor(armourClass, this.element, this.m_40402_());
            ItemStack newStack = new ItemStack((ItemLike)newItem);
            ((WizardArmorItem)newItem).setMana(newStack, this.getMana(stack));
            newStack.m_41751_(stack.m_41783_());
            upgrade.m_41774_(1);
            return newStack;
        }
        return stack;
    }

    @Override
    public boolean onApplyButtonPressed(Player player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (upgrade.m_6657_()) {
            ItemStack original = centre.m_7993_().m_41777_();
            centre.m_5852_(this.applyUpgrade(player, centre.m_7993_(), upgrade.m_7993_()));
            changed = !ItemStack.m_41656_((ItemStack)centre.m_7993_(), (ItemStack)original);
        }
        return changed |= WorkbenchUtils.rechargeManaFromCrystals(centre, crystals);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        if (this.getElement() != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.%s.wizard_armor.element_cost_reduction".formatted("ebwizardry"), (Object[])new Object[]{(int)(this.wizardArmorType.elementalCostReduction * 100.0f), this.element.getDescriptionFormatted().getString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (this.wizardArmorType == WizardArmorType.SAGE) {
            tooltip.add((Component)Component.m_237115_((String)"item.%s.wizard_armor.enchantability".formatted("ebwizardry")).m_130940_(ChatFormatting.BLUE));
        }
        if (this.wizardArmorType.cooldownReduction > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"item.%s.wizard_armor.cooldown_reduction".formatted("ebwizardry"), (Object[])new Object[]{(int)(this.wizardArmorType.cooldownReduction * 100.0f)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (this.wizardArmorType != WizardArmorType.WIZARD) {
            tooltip.add((Component)Component.m_237115_((String)"item.%s.wizard_armor.full_set".formatted("ebwizardry")).m_130940_(ChatFormatting.AQUA));
            Object[] args = new Object[]{};
            if (this.wizardArmorType == WizardArmorType.SAGE) {
                args = new Object[]{20};
            }
            if (this.wizardArmorType == WizardArmorType.WARLOCK) {
                args = new Object[]{20};
            }
            tooltip.add((Component)Component.m_237110_((String)"item.%s.%s_armor.full_set_bonus".formatted("ebwizardry", this.wizardArmorType.name().toLowerCase()), (Object[])args).m_130940_(ChatFormatting.AQUA));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 40L != 0L) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_40402_() == EquipmentSlot.HEAD && InventoryUtil.isWearingFullSet(livingEntity, this.element, this.getWizardArmorType()) && InventoryUtil.doAllArmourPiecesHaveMana(livingEntity)) {
                if (this.getWizardArmorType() == WizardArmorType.WARLOCK) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 0, false, false, false));
                    return;
                }
                if (this.getWizardArmorType() == WizardArmorType.BATTLEMAGE) {
                    livingEntity.m_7292_(new MobEffectInstance(EBMobEffects.WARD.get(), 80, 0, false, false, false));
                }
            }
        }
    }

    protected void applySpellModifiers(LivingEntity caster, Spell spell, SpellModifiers modifiers) {
        if (spell.getElement() == this.getElement()) {
            modifiers.set("cost", modifiers.get("cost") - this.getWizardArmorType().elementalCostReduction, false);
        }
        modifiers.set("potency", 2.0f, false);
        modifiers.set(EBItems.COOLDOWN_UPGRADE.get(), modifiers.get(EBItems.COOLDOWN_UPGRADE.get()) - this.getWizardArmorType().cooldownReduction, true);
        if (this.m_40402_() == EquipmentSlot.HEAD && InventoryUtil.isWearingFullSet(caster, this.element, this.getWizardArmorType()) && InventoryUtil.doAllArmourPiecesHaveMana(caster) && this.getWizardArmorType() == WizardArmorType.SAGE && spell.getElement() != this.element) {
            modifiers.set("cost", 0.8f, false);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return this.getElement() == null ? super.m_7626_(stack) : Component.m_237113_((String)super.m_7626_(stack).getString()).m_130940_(this.getElement().getColor());
    }

    public WizardArmorType getWizardArmorType() {
        return this.wizardArmorType;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public boolean validForReceptacle() {
        return false;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return DrawingUtils.mix(16747518, 9318116, this.m_142158_(stack));
    }

    @Override
    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - stack.m_41773_();
    }

    @Override
    public void setMana(ItemStack stack, int mana) {
        stack.m_41721_(this.getManaCapacity(stack) - mana);
    }

    @Override
    public int getManaCapacity(ItemStack stack) {
        return this.m_41462_();
    }

    @Override
    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return false;
    }
}

