/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.item;

import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBSounds;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public enum WizardArmorType implements ArmorMaterial
{
    WIZARD("wizard", () -> null, 15, 0.1f, 0.0f, SoundEvents.f_11673_, new int[]{2, 4, 5, 2}, 15, "hat", "robe", "leggings", "boots"),
    SAGE("sage", EBItems.RESPLENDENT_THREAD, 15, 0.2f, 0.0f, EBSounds.ITEM_ARMOUR_EQUIP_SAGE.get(), new int[]{2, 5, 6, 3}, 15, "hat", "robe", "leggings", "boots"),
    BATTLEMAGE("battlemage", EBItems.CRYSTAL_SILVER_PLATING, 15, 0.05f, 0.05f, EBSounds.ITEM_ARMOUR_EQUIP_BATTLEMAGE.get(), new int[]{3, 6, 8, 3}, 15, "helmet", "chestplate", "leggings", "boots"),
    WARLOCK("warlock", EBItems.ETHEREAL_CRYSTAL_WEAVE, 20, 0.1f, 0.1f, EBSounds.ITEM_ARMOUR_EQUIP_WARLOCK.get(), new int[]{2, 4, 5, 2}, 15, "hood", "robe", "leggings", "boots");

    final int[] protectionValues;
    final int durabilityMultiplier;
    final String name;
    final Supplier<Item> upgradeItem;
    final float elementalCostReduction;
    final float cooldownReduction;
    @Deprecated
    final Map<EquipmentSlot, String> armourPieceNames;
    final SoundEvent equipSound;
    final int enchantability;
    private final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};
    Element element = null;

    private WizardArmorType(String name, Supplier<Item> upgradeItem, int durabilityMultiplier, float elementalCostReduction, float cooldownReduction, SoundEvent equipSound, int[] protectionValues, int enchantability, String ... armourPieceNames) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.upgradeItem = upgradeItem;
        this.elementalCostReduction = elementalCostReduction;
        this.cooldownReduction = cooldownReduction;
        this.equipSound = equipSound;
        this.protectionValues = protectionValues;
        this.enchantability = enchantability;
        if (armourPieceNames.length != 4) {
            throw new IllegalArgumentException("Armour class " + name + " must have exactly 4 armour piece names. Try again!!!!!");
        }
        this.armourPieceNames = new EnumMap<EquipmentSlot, String>(EquipmentSlot.class);
        this.armourPieceNames.put(EquipmentSlot.HEAD, armourPieceNames[0]);
        this.armourPieceNames.put(EquipmentSlot.CHEST, armourPieceNames[1]);
        this.armourPieceNames.put(EquipmentSlot.LEGS, armourPieceNames[2]);
        this.armourPieceNames.put(EquipmentSlot.FEET, armourPieceNames[3]);
    }

    public int m_266425_(ArmorItem.Type type) {
        return this.BASE_DURABILITY[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionValues[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return Ingredient.f_43901_;
    }

    @NotNull
    public String m_6082_() {
        if (this.element != null) {
            return this.name + "_" + String.valueOf(this.element.getDescriptionFormatted());
        }
        return this.name;
    }

    public Map<EquipmentSlot, String> getArmourPieceNames() {
        return this.armourPieceNames;
    }

    public float m_6651_() {
        return 0.0f;
    }

    public float m_6649_() {
        return 0.0f;
    }
}

