/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.loot;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.spell.Element;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellContext;
import com.binaris.wizardry.api.content.spell.SpellTier;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBLootFunctions;
import com.binaris.wizardry.setup.registries.Spells;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomSpellFunction
extends LootItemConditionalFunction {
    @Nullable
    private final List<Spell> spells;
    @Nullable
    private final List<Element> elements;
    @Nullable
    private final List<SpellTier> tiers;
    private final boolean ignoreWeighting;
    private final float undiscoveredBias;

    protected RandomSpellFunction(LootItemCondition[] conditions, @Nullable List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, @Nullable List<SpellTier> tiers, @Nullable List<Element> elements) {
        super(conditions);
        this.spells = spells;
        this.ignoreWeighting = ignoreWeighting;
        this.undiscoveredBias = undiscoveredBias;
        this.tiers = tiers;
        this.elements = elements;
    }

    public static LootItemConditionalFunction.Builder<?> setRandomSpell(List<Spell> spells, boolean ignoreWeighting, float undiscoveredBias, List<SpellTier> tiers, List<Element> elements) {
        return RandomSpellFunction.m_80683_(conditions -> new RandomSpellFunction((LootItemCondition[])conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements));
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return EBLootFunctions.RANDOM_SPELL;
    }

    @NotNull
    protected ItemStack m_7372_(ItemStack stack, @NotNull LootContext lootContext) {
        if (!(stack.m_41720_() instanceof SpellBookItem) && !(stack.m_41720_() instanceof ScrollItem)) {
            EBLogger.warn("Applying the random_spell loot function to an item that isn't a spell book or scroll.", new Object[0]);
        }
        SpellContext context = !lootContext.m_78936_(LootContextParams.f_81455_) ? SpellContext.TREASURE : SpellContext.LOOTING;
        Player player = (Player)lootContext.m_78953_(LootContextParams.f_81456_);
        Spell spell = this.pickRandomSpell(stack, lootContext.m_230907_(), context, player);
        if (spell == Spells.NONE) {
            return SpellUtil.setSpell(stack, Spells.MAGIC_MISSILE);
        }
        return SpellUtil.setSpell(stack, spell);
    }

    private Spell pickRandomSpell(ItemStack stack, RandomSource random, SpellContext context, Player player) {
        ArrayList<Spell> possibleSpells = new ArrayList<Spell>(Services.REGISTRY_UTIL.getSpells());
        if (this.spells != null && !this.spells.isEmpty()) {
            possibleSpells.retainAll(this.spells);
        }
        possibleSpells.removeIf(possibleSpell -> !possibleSpell.isEnabled(context));
        if (this.tiers != null && !this.tiers.isEmpty()) {
            possibleSpells.removeIf(possibleSpell -> !this.tiers.contains(possibleSpell.getTier()));
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            possibleSpells.removeIf(possibleSpell -> !this.elements.contains(possibleSpell.getElement()));
        }
        if (stack.m_41720_() instanceof SpellBookItem) {
            possibleSpells.removeIf(spell -> !spell.isEnabled(SpellContext.BOOK));
        }
        if (stack.m_41720_() instanceof ScrollItem) {
            possibleSpells.removeIf(spell -> !spell.isEnabled(SpellContext.SCROLL));
        }
        if (player != null && this.undiscoveredBias > 0.0f) {
            float bias = this.undiscoveredBias;
            if (EBAccessoriesIntegration.isEquipped(player, EBItems.CHARM_SPELL_DISCOVERY.get())) {
                bias = Math.min(bias + 0.4f, 0.9f);
            }
            if (bias > 0.0f) {
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
                int discoveredCount = (int)possibleSpells.stream().filter(data::hasSpellBeenDiscovered).count();
                if (discoveredCount > 0 && discoveredCount < possibleSpells.size()) {
                    boolean keepDiscovered = random.m_188501_() > 0.5f + 0.5f * this.undiscoveredBias;
                    possibleSpells.removeIf(s -> keepDiscovered != data.hasSpellBeenDiscovered((Spell)s));
                }
            }
        }
        if (possibleSpells.isEmpty()) {
            return Spells.NONE;
        }
        return possibleSpells.get(random.m_188503_(possibleSpells.size()));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomSpellFunction> {
        public void serialize(@NotNull JsonObject object, @NotNull RandomSpellFunction function, @NotNull JsonSerializationContext serializationContext) {
            DataResult result;
            if (function.spells != null && !function.spells.isEmpty()) {
                result = ResourceLocation.f_135803_.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.spells.stream().map(Spell::getLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("spells", jsonElement));
            }
            object.addProperty("ignore_weighting", Boolean.valueOf(function.ignoreWeighting));
            object.addProperty("undiscovered_bias", (Number)Float.valueOf(function.undiscoveredBias));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                result = ResourceLocation.f_135803_.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.tiers.stream().map(SpellTier::getOrCreateLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("tiers", jsonElement));
            }
            if (function.elements != null && !function.elements.isEmpty()) {
                result = ResourceLocation.f_135803_.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, function.elements.stream().map(Element::getLocation).collect(Collectors.toList()));
                result.result().ifPresent(jsonElement -> object.add("elements", jsonElement));
            }
        }

        @NotNull
        public RandomSpellFunction deserialize(JsonObject object, @NotNull JsonDeserializationContext deserializationContext, LootItemCondition @NotNull [] conditions) {
            DataResult result;
            DataResult result2;
            List<Spell> spells = null;
            List tiers = null;
            List elements = null;
            if (object.has("spells") && (result2 = ResourceLocation.f_135803_.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("spells"))).result().isPresent()) {
                spells = ((List)result2.result().get()).stream().map(Services.REGISTRY_UTIL::getSpell).collect(Collectors.toList());
            }
            boolean ignoreWeighting = GsonHelper.m_13855_((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            float undiscoveredBias = GsonHelper.m_13820_((JsonObject)object, (String)"undiscovered_bias", (float)0.0f);
            if (object.has("tiers") && (result = ResourceLocation.f_135803_.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("tiers"))).result().isPresent()) {
                tiers = ((List)result.result().get()).stream().map(Services.REGISTRY_UTIL::getTier).collect(Collectors.toList());
                if (tiers.contains(null)) {
                    EBLogger.warn("One or more invalid spell tiers found when deserializing random_spell loot function from " + object.toString(), new Object[0]);
                    tiers.removeIf(Objects::isNull);
                }
            }
            if (object.has("elements") && (result = ResourceLocation.f_135803_.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("elements"))).result().isPresent()) {
                elements = ((List)result.result().get()).stream().map(Services.REGISTRY_UTIL::getElement).collect(Collectors.toList());
                if (elements.contains(null)) {
                    EBLogger.warn("One or more invalid elements found when deserializing random_spell loot function from " + object.toString(), new Object[0]);
                    elements.removeIf(Objects::isNull);
                }
            }
            return new RandomSpellFunction(conditions, spells, ignoreWeighting, undiscoveredBias, tiers, elements);
        }
    }
}

