/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.loot;

import com.binaris.wizardry.api.EBLogger;
import com.binaris.wizardry.api.content.entity.living.ISpellCaster;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.util.SpellUtil;
import com.binaris.wizardry.content.item.ScrollItem;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.setup.registries.EBLootFunctions;
import com.binaris.wizardry.setup.registries.Spells;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class WizardSpellFunction
extends LootItemConditionalFunction {
    protected WizardSpellFunction(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return EBLootFunctions.WIZARD_SPELL;
    }

    @NotNull
    protected ItemStack m_7372_(ItemStack stack, @NotNull LootContext context) {
        if (!(stack.m_41720_() instanceof SpellBookItem) && !(stack.m_41720_() instanceof ScrollItem)) {
            EBLogger.warn("Applying the wizard_spell loot function to an item that isn't a spell book or scroll.", new Object[0]);
        }
        if (!(context.m_165124_(LootContextParams.f_81455_) instanceof ISpellCaster)) {
            EBLogger.warn("Applying the wizard_spell loot function to an entity that isn't a spell caster.", new Object[0]);
            return stack;
        }
        List<Spell> spells = ((ISpellCaster)context.m_165124_(LootContextParams.f_81455_)).getSpells();
        spells.remove(Spells.MAGIC_MISSILE);
        if (spells.isEmpty()) {
            EBLogger.warn("Tried to apply the wizard_spell loot function to an item, but none of the looted entity's spells were applicable for that item. This is probably a bug!", new Object[0]);
            return stack;
        }
        SpellUtil.setSpell(stack, spells.get(context.m_230907_().m_188503_(spells.size())));
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<WizardSpellFunction> {
        public void serialize(@NotNull JsonObject json, @NotNull WizardSpellFunction loot, @NotNull JsonSerializationContext context) {
        }

        @NotNull
        public WizardSpellFunction deserialize(@NotNull JsonObject object, @NotNull JsonDeserializationContext context, LootItemCondition @NotNull [] conditions) {
            return new WizardSpellFunction(conditions);
        }
    }
}

