/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.menu;

import com.binaris.wizardry.api.content.event.SpellBindEvent;
import com.binaris.wizardry.api.content.item.IWorkbenchItem;
import com.binaris.wizardry.client.EBClientConstants;
import com.binaris.wizardry.content.item.SpellBookItem;
import com.binaris.wizardry.content.menu.slot.SlotItemClassList;
import com.binaris.wizardry.content.menu.slot.SlotItemList;
import com.binaris.wizardry.content.menu.slot.SlotWorkbenchItem;
import com.binaris.wizardry.core.event.WizardryEventBus;
import com.binaris.wizardry.core.mixin.accessor.SlotAccessor;
import com.binaris.wizardry.setup.registries.EBAdvancementTriggers;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMenus;
import com.binaris.wizardry.setup.registries.WandUpgrades;
import java.util.HashSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcaneWorkbenchMenu
extends AbstractContainerMenu {
    public static final int CRYSTAL_SLOT = 8;
    public static final int CENTRE_SLOT = 9;
    public static final int UPGRADE_SLOT = 10;
    public static final int SLOT_RADIUS = 42;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public Container container;
    public boolean needsRefresh;

    public ArcaneWorkbenchMenu(int i, Inventory playerInv) {
        this(i, playerInv, (Container)new SimpleContainer(11));
    }

    public ArcaneWorkbenchMenu(int id, Inventory inventory, Container container) {
        super(EBMenus.ARCANE_WORKBENCH_MENU.get(), id);
        this.container = container;
        ItemStack wand = container.m_8020_(9);
        for (int i = 0; i < 8; ++i) {
            this.m_38897_(new SlotItemClassList(container, i, -999, -999, 1, SpellBookItem.class));
        }
        this.m_38897_(new SlotItemList(container, 8, 13, 101, 64, EBClientConstants.ARCANE_WORKBENCH_EMPTY_SLOT_CRYSTAL, EBItems.MAGIC_CRYSTAL.get(), EBItems.MAGIC_CRYSTAL_SHARD.get(), EBItems.MAGIC_CRYSTAL_GRAND.get(), EBItems.MAGIC_CRYSTAL_EARTH.get(), EBItems.MAGIC_CRYSTAL_FIRE.get(), EBItems.MAGIC_CRYSTAL_HEALING.get(), EBItems.MAGIC_CRYSTAL_ICE.get(), EBItems.MAGIC_CRYSTAL_LIGHTNING.get(), EBItems.MAGIC_CRYSTAL_NECROMANCY.get(), EBItems.MAGIC_CRYSTAL_SORCERY.get()));
        this.m_38897_(new SlotWorkbenchItem(container, 9, 80, 64, this));
        HashSet<Item> upgrades = new HashSet<Item>(WandUpgrades.getSpecialUpgrades());
        upgrades.add(EBItems.ARCANE_TOME.get());
        upgrades.add(EBItems.RESPLENDENT_THREAD.get());
        upgrades.add(EBItems.CRYSTAL_SILVER_PLATING.get());
        upgrades.add(EBItems.ETHEREAL_CRYSTAL_WEAVE.get());
        this.m_38897_(new SlotItemList(container, 10, 147, 17, 1, EBClientConstants.ARCANE_WORKBENCH_EMPTY_SLOT_UPGRADE, upgrades.toArray(new Item[0])));
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 196));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, 9 + x + y * 9, 8 + x * 18, 138 + y * 18));
            }
        }
        this.onSlotChanged(9, wand, null);
    }

    private static int getBookSlotXOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * Mth.m_14031_((float)angle));
    }

    private static int getBookSlotYOffset(int i, int bookSlotCount) {
        float angle = (float)i * ((float)Math.PI * 2) / (float)bookSlotCount;
        return Math.round(42.0f * -Mth.m_14089_((float)angle));
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        int[] slotRange;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return itemstack;
        }
        ItemStack itemstack1 = slot.m_7993_();
        itemstack = itemstack1.m_41777_();
        if (index < 11 ? !this.m_38903_(itemstack1, 11, 47, true) : index < 47 && (slotRange = this.findSlotRangeForItem(itemstack1)) != null && !this.m_38903_(itemstack1, slotRange[0], slotRange[1] + 1, false)) {
            return ItemStack.f_41583_;
        }
        if (itemstack1.m_41619_()) {
            slot.m_269060_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (itemstack1.m_41613_() == itemstack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, itemstack1);
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player);
    }

    public void onSlotChanged(int slotNumber, ItemStack stack, Player player) {
        if (slotNumber != 9) {
            return;
        }
        if (stack.m_41619_()) {
            for (int i = 0; i < 8; ++i) {
                this.hideSlot(i, player);
            }
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof IWorkbenchItem) {
            int i;
            IWorkbenchItem workbenchItem = (IWorkbenchItem)item;
            int spellSlots = workbenchItem.getSpellSlotCount(stack);
            int centreX = this.m_38853_((int)9).f_40220_;
            int centreY = this.m_38853_((int)9).f_40221_;
            for (i = 0; i < spellSlots; ++i) {
                int x = centreX + ArcaneWorkbenchMenu.getBookSlotXOffset(i, spellSlots);
                int y = centreY + ArcaneWorkbenchMenu.getBookSlotYOffset(i, spellSlots);
                this.showSlot(i, x, y);
            }
            for (i = spellSlots; i < 8; ++i) {
                this.hideSlot(i, player);
            }
        }
    }

    public void onApplyButtonPressed(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (WizardryEventBus.getInstance().fire(new SpellBindEvent(player, this))) {
            return;
        }
        Slot centre = this.m_38853_(9);
        Item item = centre.m_7993_().m_41720_();
        if (item instanceof IWorkbenchItem) {
            IWorkbenchItem workbenchItem = (IWorkbenchItem)item;
            Slot[] spellBooks = this.f_38839_.subList(0, 8).toArray(new Slot[8]);
            if (workbenchItem.onApplyButtonPressed(player, centre, this.m_38853_(8), this.m_38853_(10), spellBooks) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EBAdvancementTriggers.ARCANE_WORKBENCH.trigger(serverPlayer, centre.m_7993_());
            }
        }
    }

    public void onClearButtonPressed(Player player) {
        Slot centre = this.m_38853_(9);
        Item item = centre.m_7993_().m_41720_();
        if (item instanceof IWorkbenchItem) {
            IWorkbenchItem workbenchItem = (IWorkbenchItem)item;
            Slot[] spellBooks = this.f_38839_.subList(0, 8).toArray(new Slot[8]);
            workbenchItem.onClearButtonPressed(player, centre, this.m_38853_(8), this.m_38853_(10), spellBooks);
        }
    }

    private void showSlot(int index, int x, int y) {
        Slot slot = this.m_38853_(index);
        ((SlotAccessor)slot).setX(x);
        ((SlotAccessor)slot).setY(y);
    }

    private void hideSlot(int index, Player player) {
        Slot slot = this.m_38853_(index);
        ((SlotAccessor)slot).setX(-999);
        ((SlotAccessor)slot).setY(-999);
        ItemStack stack = slot.m_7993_();
        ItemStack rest = this.m_7648_(player, index);
        if (rest == ItemStack.f_41583_ && stack != ItemStack.f_41583_) {
            slot.m_5852_(ItemStack.f_41583_);
            player.m_36176_(stack, false);
        }
    }

    public int @Nullable [] findSlotRangeForItem(ItemStack stack) {
        if (this.m_38853_(0).m_5857_(stack)) {
            int spellSlots;
            ItemStack centreStack = this.m_38853_(9).m_7993_();
            if (centreStack.m_41720_() instanceof IWorkbenchItem && (spellSlots = ((IWorkbenchItem)centreStack.m_41720_()).getSpellSlotCount(centreStack)) > 0) {
                return new int[]{0, spellSlots - 1};
            }
        } else {
            if (this.m_38853_(8).m_5857_(stack)) {
                return new int[]{8, 8};
            }
            if (this.m_38853_(9).m_5857_(stack)) {
                return new int[]{9, 9};
            }
            if (this.m_38853_(10).m_5857_(stack)) {
                return new int[]{10, 10};
            }
        }
        return null;
    }
}

