/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.menu;

import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMenus;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class BookshelfMenu
extends AbstractContainerMenu {
    private static final Set<Item> validItems = new HashSet<Item>();
    public Container container;

    public BookshelfMenu(int i, Inventory inventory) {
        this(i, inventory, (Container)new SimpleContainer(12));
    }

    public BookshelfMenu(int i, Inventory inventory, Container container) {
        super(EBMenus.BOOKSHELF_MENU.get(), i);
        int x;
        int y;
        this.container = container;
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 6; ++x) {
                this.m_38897_(new SlotBookshelf(container, x + 6 * y, 35 + x * 18, 17 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)inventory, x2, 8 + x2 * 18, 124));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, 9 + x + y * 9, 8 + x * 18, 66 + y * 18));
            }
        }
    }

    public static boolean isBook(ItemStack stack) {
        return validItems.contains(stack.m_41720_());
    }

    public static void registerBookItem(Item item) {
        validItems.add(item);
    }

    public static void initBookItems() {
        BookshelfMenu.registerBookItem(Items.f_42517_);
        BookshelfMenu.registerBookItem(Items.f_42615_);
        BookshelfMenu.registerBookItem(Items.f_42614_);
        BookshelfMenu.registerBookItem(Items.f_42690_);
        BookshelfMenu.registerBookItem(EBItems.SPELL_BOOK.get());
        BookshelfMenu.registerBookItem(EBItems.ARCANE_TOME.get());
        BookshelfMenu.registerBookItem(EBItems.RUINED_SPELL_BOOK.get());
        BookshelfMenu.registerBookItem(EBItems.SCROLL.get());
        BookshelfMenu.registerBookItem(EBItems.BLANK_SCROLL.get());
        BookshelfMenu.registerBookItem(EBItems.IDENTIFICATION_SCROLL.get());
        BookshelfMenu.registerBookItem(EBItems.STORAGE_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.SIPHON_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.CONDENSER_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.RANGE_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.DURATION_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.COOLDOWN_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.BLAST_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.ATTUNEMENT_UPGRADE.get());
        BookshelfMenu.registerBookItem(EBItems.MELEE_UPGRADE.get());
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int clickedSlotId) {
        ItemStack remainder = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(clickedSlotId);
        if (!slot.m_6657_()) {
            return remainder;
        }
        ItemStack stack = slot.m_7993_();
        remainder = stack.m_41777_();
        if (clickedSlotId < 12) {
            if (!this.m_38903_(stack, 12, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            int minSlotId = 0;
            int maxSlotId = 11;
            if (!BookshelfMenu.isBook(stack)) {
                return ItemStack.f_41583_;
            }
            if (!this.m_38903_(stack, minSlotId, maxSlotId + 1, false)) {
                return ItemStack.f_41583_;
            }
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == remainder.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return remainder;
    }

    public static class SlotBookshelf
    extends Slot {
        public SlotBookshelf(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return BookshelfMenu.isBook(stack);
        }
    }
}

