/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.recipe;

import com.binaris.wizardry.setup.registries.EBRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ImbuementAltarRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> receptacleIngredients;
    private final Ingredient centerIngredient;
    private final ItemStack output;

    public ImbuementAltarRecipe(ResourceLocation id, NonNullList<Ingredient> receptacleIngredients, Ingredient centerIngredient, ItemStack output) {
        this.id = id;
        this.receptacleIngredients = receptacleIngredients;
        this.centerIngredient = centerIngredient;
        this.output = output;
    }

    private static ItemStack itemStackFromJson(JsonObject stackObject) {
        Item item = ShapedRecipe.m_151278_((JsonObject)stackObject);
        int count = GsonHelper.m_13824_((JsonObject)stackObject, (String)"count", (int)1);
        if (count < 1) {
            throw new JsonSyntaxException("Invalid output count: " + count);
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (stackObject.has("nbt")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)stackObject, (String)"nbt"));
                stack.m_41751_(nbt);
            }
            catch (Exception e) {
                throw new JsonParseException("Invalid NBT data: " + e.getMessage());
            }
        }
        return stack;
    }

    public boolean matches(ItemStack centerStack, ItemStack[] receptacleStacks) {
        if (receptacleStacks.length != 4) {
            return false;
        }
        if (!this.centerIngredient.test(centerStack)) {
            return false;
        }
        boolean[] matched = new boolean[4];
        block0: for (int i = 0; i < 4; ++i) {
            if (receptacleStacks[i].m_41619_()) {
                return false;
            }
            for (int j = 0; j < this.receptacleIngredients.size(); ++j) {
                if (matched[j] || !((Ingredient)this.receptacleIngredients.get(j)).test(receptacleStacks[i])) continue;
                matched[j] = true;
                continue block0;
            }
        }
        for (boolean m : matched) {
            if (m) continue;
            return false;
        }
        return true;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return EBRecipeTypes.IMBUEMENT_ALTAR_SERIALIZER;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return EBRecipeTypes.IMBUEMENT_ALTAR;
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> getReceptacleIngredients() {
        return this.receptacleIngredients;
    }

    public Ingredient getCenterIngredient() {
        return this.centerIngredient;
    }

    public static class Serializer
    implements RecipeSerializer<ImbuementAltarRecipe> {
        @NotNull
        public ImbuementAltarRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            NonNullList receptacleIngredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            JsonArray receptaclesArray = GsonHelper.m_13933_((JsonObject)json, (String)"receptacles");
            if (receptaclesArray.size() != 4) {
                throw new JsonParseException("Imbuement recipe must have exactly 4 receptacle ingredients");
            }
            for (int i = 0; i < 4; ++i) {
                receptacleIngredients.set(i, (Object)Ingredient.m_43917_((JsonElement)receptaclesArray.get(i)));
            }
            Ingredient centerIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"center"));
            ItemStack output = ImbuementAltarRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ImbuementAltarRecipe(id, (NonNullList<Ingredient>)receptacleIngredients, centerIngredient, output);
        }

        @NotNull
        public ImbuementAltarRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            NonNullList receptacleIngredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            for (int i = 0; i < 4; ++i) {
                receptacleIngredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            Ingredient centerIngredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return new ImbuementAltarRecipe(id, (NonNullList<Ingredient>)receptacleIngredients, centerIngredient, output);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, ImbuementAltarRecipe recipe) {
            for (Ingredient ingredient : recipe.receptacleIngredients) {
                ingredient.m_43923_(buf);
            }
            recipe.centerIngredient.m_43923_(buf);
            buf.m_130055_(recipe.output);
        }
    }
}

