/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AreaEffectSpell
extends Spell {
    protected boolean targetAllies = false;
    protected boolean alwaysSucceed = false;
    protected float particleDensity = 0.65f;

    public AreaEffectSpell targetAllies(boolean targetAllies) {
        this.targetAllies = targetAllies;
        return this;
    }

    public AreaEffectSpell alwaysSucceed(boolean alwaysSucceed) {
        this.alwaysSucceed = alwaysSucceed;
        return this;
    }

    public AreaEffectSpell particleDensity(float particleDensity) {
        this.particleDensity = particleDensity;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.caster().m_20182_());
        if (result) {
            this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        }
        return result;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.caster().m_20182_());
        if (result) {
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        }
        return result;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        boolean result = this.findAndAffectEntities(ctx, ctx.vec3());
        if (result) {
            this.playSound(ctx.world(), ctx.vec3(), ctx.castingTicks(), -1);
        }
        return result;
    }

    protected boolean findAndAffectEntities(CastContext ctx, Vec3 origin) {
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(radius, origin.f_82479_, origin.f_82480_, origin.f_82481_, ctx.world());
        if (this.targetAllies) {
            targets.removeIf(target -> target != ctx.caster() && !AllyDesignation.isAllied(ctx.caster(), (Entity)target));
        } else {
            targets.removeIf(target -> !AllyDesignation.isValidTarget((Entity)ctx.caster(), (Entity)target));
        }
        targets.sort(Comparator.comparingDouble(e -> e.m_20275_(origin.f_82479_, origin.f_82480_, origin.f_82481_)));
        boolean result = this.alwaysSucceed;
        int i = 0;
        for (LivingEntity target2 : targets) {
            if (!this.affectEntity(ctx, origin, target2, i++)) continue;
            result = true;
        }
        if (ctx.world().f_46443_) {
            this.spawnParticleEffect(ctx, origin, radius);
        }
        return result;
    }

    protected abstract boolean affectEntity(CastContext var1, Vec3 var2, LivingEntity var3, int var4);

    protected void spawnParticleEffect(CastContext ctx, Vec3 origin, double radius) {
        int particleCount = (int)Math.round((double)this.particleDensity * Math.PI * radius * radius);
        for (int i = 0; i < particleCount; ++i) {
            double r = 1.0 + ctx.world().f_46441_.m_188500_() * (radius - 1.0);
            float angle = ctx.world().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            this.spawnParticle(ctx.world(), origin.f_82479_ + r * (double)Mth.m_14089_((float)angle), origin.f_82480_, origin.f_82481_ + r * (double)Mth.m_14031_((float)angle));
        }
    }

    protected void spawnParticle(Level world, double x, double y, double z) {
    }
}

