/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.projectile.MagicArrowEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowSpell<T extends MagicArrowEntity>
extends Spell {
    protected final Function<Level, T> arrowFactory;

    public ArrowSpell(Function<Level, T> arrowFactory) {
        this.arrowFactory = arrowFactory;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.world().f_46443_) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            arrow.aim((LivingEntity)ctx.caster(), this.calculateVelocity(ctx, arrow, ctx.caster().m_20192_()) - 0.3f);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, (LivingEntity)ctx.caster());
            ctx.world().m_7967_((Entity)arrow);
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (!ctx.world().f_46443_) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            int aimingError = EntityUtil.getDefaultAimingError(ctx.world().m_46791_());
            arrow.aim(ctx.caster(), (Entity)ctx.target(), this.calculateVelocity(ctx, arrow, ctx.caster().m_20192_() - 0.3f), aimingError);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, ctx.caster());
            ctx.world().m_7967_((Entity)arrow);
        }
        ctx.caster().m_6674_(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!ctx.world().f_46443_) {
            MagicArrowEntity arrow = (MagicArrowEntity)((Object)this.arrowFactory.apply(ctx.world()));
            arrow.m_146884_(ctx.vec3());
            Vec3 vec = Vec3.m_82528_((Vec3i)ctx.direction().m_122436_());
            arrow.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), this.calculateVelocity(ctx, arrow, 0.375f), 1.0f);
            arrow.damageMultiplier = ctx.modifiers().get("potency");
            this.addArrowExtras(arrow, null);
            ctx.world().m_7967_((Entity)arrow);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    public float calculateVelocity(CastContext ctx, MagicArrowEntity projectile, float launchHeight) {
        float range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (projectile.m_20068_()) {
            if (projectile.getLifetime() <= 0) {
                return 2.0f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.05f;
        return range / Mth.m_14116_((float)(2.0f * launchHeight / g));
    }

    protected void addArrowExtras(T arrow, @Nullable LivingEntity caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

