/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class BuffSpell
extends Spell {
    protected final Supplier<MobEffect>[] effects;
    protected final float r;
    protected final float g;
    protected final float b;
    protected Set<MobEffect> potionSet = new HashSet<MobEffect>();
    protected float particleCount = 10.0f;

    @SafeVarargs
    public BuffSpell(float r, float g, float b, Supplier<MobEffect> ... effects) {
        this.effects = effects;
        this.r = r;
        this.g = g;
        this.b = b;
        for (Supplier<MobEffect> effect : effects) {
            this.potionSet.add(effect.get());
        }
    }

    public static int getStandardBonusAmplifier(float potencyModifier) {
        return (int)((double)(potencyModifier - 1.0f) / 0.4);
    }

    public static SpellProperty<Integer> getEffectDurationProperty(MobEffect effect) {
        return SpellProperty.intProperty(effect.m_19481_() + "_duration");
    }

    public static SpellProperty<Integer> getEffectStrengthProperty(MobEffect effect) {
        return SpellProperty.intProperty(effect.m_19481_() + "_strength");
    }

    public BuffSpell particleCount(int particleCount) {
        this.particleCount = particleCount;
        return this;
    }

    public Set<MobEffect> getPotionSet() {
        return Collections.unmodifiableSet(this.potionSet);
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!this.applyEffects(ctx, (LivingEntity)ctx.caster())) {
            return false;
        }
        if (ctx.world().f_46443_) {
            this.spawnParticles(ctx.world(), (LivingEntity)ctx.caster());
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (!this.potionSet.isEmpty() && ctx.caster().m_21221_().keySet().containsAll(this.potionSet)) {
            return false;
        }
        if (!this.applyEffects(ctx, ctx.caster()) && !ctx.world().f_46443_) {
            return false;
        }
        if (ctx.world().f_46443_) {
            this.spawnParticles(ctx.world(), ctx.caster());
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        AABB boundingBox = new AABB(ctx.pos());
        List entities = ctx.world().m_45976_(LivingEntity.class, boundingBox);
        float distance = -1.0f;
        LivingEntity nearestEntity = null;
        for (LivingEntity entity : entities) {
            float newDistance = (float)entity.m_20275_(ctx.x(), ctx.y(), ctx.z());
            if (distance != -1.0f && !(newDistance < distance)) continue;
            distance = newDistance;
            nearestEntity = entity;
        }
        if (nearestEntity == null) {
            return false;
        }
        if (!this.applyEffects(ctx, nearestEntity) && !ctx.world().f_46443_) {
            return false;
        }
        if (ctx.world().f_46443_) {
            this.spawnParticles(ctx.world(), nearestEntity);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected boolean applyEffects(CastContext ctx, LivingEntity caster) {
        int bonusAmplifier = this.getBonusAmplifier(ctx.modifiers().get("potency"));
        for (MobEffect effect : this.potionSet) {
            if (ctx.world().f_46443_) continue;
            caster.m_7292_(new MobEffectInstance(effect, effect.m_8093_() ? 1 : (int)((float)this.property(BuffSpell.getEffectDurationProperty(effect)).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(BuffSpell.getEffectStrengthProperty(effect)) + bonusAmplifier, false, true));
        }
        return true;
    }

    protected void spawnParticles(Level world, LivingEntity caster) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.f_19854_ + world.f_46441_.m_188500_() * 2.0 - 1.0;
            double y = caster.f_19855_ + (double)caster.m_20192_() - 0.5 + world.f_46441_.m_188500_();
            double z = caster.f_19856_ + world.f_46441_.m_188500_() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(this.r, this.g, this.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create(EBParticles.BUFF).entity((Entity)caster).color(this.r, this.g, this.b).spawn(world);
    }

    protected int getBonusAmplifier(float potencyModifier) {
        return BuffSpell.getStandardBonusAmplifier(potencyModifier);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

