/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ConjureData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ConjureItemSpell
extends Spell {
    public static Set<Item> SUPPORTED_ITEMS = new HashSet<Item>();
    private final Item item;

    public ConjureItemSpell(Item item) {
        this.item = item;
        ConjureItemSpell.registerSupportedItem(item);
    }

    public static boolean isSummoned(ItemStack stack) {
        if (!ConjureItemSpell.isSummonableItem(stack)) {
            return false;
        }
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        return data != null && data.isSummoned();
    }

    public static boolean isSummonableItem(Item item) {
        return SUPPORTED_ITEMS.contains(item);
    }

    public static boolean isSummonableItem(ItemStack stack) {
        return ConjureItemSpell.isSummonableItem(stack.m_41720_());
    }

    public static void registerSupportedItem(Item item) {
        SUPPORTED_ITEMS.add(item);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (this.conjureItem(ctx)) {
            if (ctx.world().f_46443_) {
                this.spawnParticles(ctx);
            }
            this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    protected void spawnParticles(PlayerCastContext ctx) {
        for (int i = 0; i < 10; ++i) {
            double x = ctx.caster().f_19854_ + ctx.world().f_46441_.m_188500_() * 2.0 - 1.0;
            double y = ctx.caster().f_19855_ + (double)ctx.caster().m_20192_() - 0.5 + ctx.world().f_46441_.m_188500_();
            double z = ctx.caster().f_19856_ + ctx.world().f_46441_.m_188500_() * 2.0 - 1.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.1, 0.0).color(0.7f, 0.9f, 1.0f).spawn(ctx.world());
        }
    }

    protected boolean conjureItem(PlayerCastContext ctx) {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        stack = this.addItemExtras(ctx, stack);
        ConjureData data = Services.OBJECT_DATA.getConjureData(stack);
        int duration = this.property(DefaultProperties.ITEM_LIFETIME);
        long currentGameTime = ctx.world().m_46467_();
        data.setExpireTime(currentGameTime + (long)duration);
        data.setDuration(duration);
        data.setSummoned(true);
        if (!ctx.caster().m_36356_(stack)) {
            ctx.caster().m_213846_((Component)Component.m_237115_((String)"spell.ebwizardry:conjure_item.no_space"));
            return false;
        }
        return true;
    }

    protected ItemStack addItemExtras(PlayerCastContext ctx, ItemStack stack) {
        return stack;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

