/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ConstructRangedSpell<T extends MagicConstructEntity>
extends ConstructSpell<T> {
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = false;

    public ConstructRangedSpell(Function<Level, T> constructFactory, boolean permanent) {
        super(constructFactory, permanent);
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(PlayerCastContext ctx) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        HitResult rayTrace = RayTracer.standardBlockRayTrace(ctx.world(), (LivingEntity)ctx.caster(), range, this.hitLiquids, this.ignoreUncollidables, false);
        if (rayTrace instanceof BlockHitResult) {
            BlockHitResult blockTrace = (BlockHitResult)rayTrace;
            Direction direction = blockTrace.m_82434_();
            if (this.requiresFloor && !ctx.caster().m_20096_()) {
                return false;
            }
            if (ctx.world().f_46443_ || direction != Direction.UP && this.requiresFloor) return false;
            if (!this.spawnConstruct(ctx, blockTrace.m_82450_(), direction)) {
                return false;
            }
        } else {
            if (this.requiresFloor || ctx.world().f_46443_) return false;
            Vec3 look = ctx.caster().m_20154_();
            Vec3 origin = ctx.caster().m_20182_().m_82520_(0.0, (double)ctx.caster().m_20192_(), 0.0);
            Vec3 target = origin.m_82549_(look.m_82490_(range));
            if (!this.spawnConstruct(ctx, target, null)) {
                return false;
            }
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        BlockHitResult blockHit;
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (ctx.target() == null) {
            return false;
        }
        if ((double)ctx.caster().m_20270_((Entity)ctx.target()) >= range || ctx.world().f_46443_) {
            return false;
        }
        Vec3 origin = ctx.caster().m_20299_(1.0f);
        BlockHitResult hit = ctx.world().m_45547_(new ClipContext(origin, ctx.target().m_20182_(), ClipContext.Block.COLLIDER, this.hitLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, null));
        if (hit instanceof BlockHitResult && !(blockHit = hit).m_82425_().equals((Object)ctx.caster().m_20183_())) {
            return false;
        }
        Direction side = null;
        int y = (int)ctx.target().m_20186_();
        if (!ctx.target().m_20096_() && this.requiresFloor) {
            Integer floor = BlockUtil.getNearestFloor(ctx.world(), ctx.target().m_20183_(), 3);
            if (floor == null) {
                return false;
            }
            side = Direction.UP;
            y = floor;
        }
        if (!this.spawnConstruct(ctx, new Vec3(ctx.target().m_20185_(), (double)y, ctx.target().m_20189_()), side)) {
            return false;
        }
        ctx.caster().m_6674_(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cast(LocationCastContext ctx) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        Vec3 endpoint = ctx.vec3().m_82549_(Vec3.m_82528_((Vec3i)ctx.direction().m_122436_()).m_82490_(range));
        BlockHitResult rayTrace = ctx.world().m_45547_(new ClipContext(ctx.vec3(), endpoint, ClipContext.Block.COLLIDER, this.hitLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, null));
        if (rayTrace instanceof BlockHitResult) {
            BlockHitResult blockHit = rayTrace;
            Direction direction = blockHit.m_82434_();
            if (direction != Direction.UP && this.requiresFloor) return false;
            if (!ctx.world().f_46443_ && !this.spawnConstruct(ctx, blockHit.m_82450_(), direction)) {
                return false;
            }
        } else {
            if (this.requiresFloor || ctx.world().f_46443_) return false;
            if (!this.spawnConstruct(ctx, endpoint, null)) {
                return false;
            }
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }
}

