/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.construct.MagicConstructEntity;
import com.binaris.wizardry.api.content.entity.construct.ScaledConstructEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructSpell<T extends MagicConstructEntity>
extends Spell {
    protected final Function<Level, T> constructFactory;
    protected final boolean permanent;
    protected boolean requiresFloor = false;
    protected boolean allowOverlap = false;

    public ConstructSpell(Function<Level, T> constructFactory, boolean permanent) {
        this.constructFactory = constructFactory;
        this.permanent = permanent;
    }

    public ConstructSpell<T> floor(boolean requiresFloor) {
        this.requiresFloor = requiresFloor;
        return this;
    }

    public ConstructSpell<T> overlap(boolean allowOverlap) {
        this.allowOverlap = allowOverlap;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (ctx.caster().m_20096_() || !this.requiresFloor) {
            if (!this.spawnConstruct(ctx, ctx.caster().m_20182_(), (Direction)(ctx.caster().m_20096_() ? Direction.UP : null))) {
                return false;
            }
            this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() != null && (ctx.caster().m_20096_() || !this.requiresFloor)) {
            if (!this.spawnConstruct(ctx, ctx.caster().m_20182_(), (Direction)(ctx.caster().m_20096_() ? Direction.UP : null))) {
                return false;
            }
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        Integer floor = ctx.pos().m_123342_();
        if (this.requiresFloor) {
            floor = BlockUtil.getNearestFloor(ctx.world(), ctx.pos(), 1);
            ctx.direction(Direction.UP);
        }
        if (floor != null) {
            if (!this.spawnConstruct(ctx, new Vec3(ctx.x(), (double)floor.intValue(), ctx.z()), ctx.direction())) {
                return false;
            }
            this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
            return true;
        }
        return false;
    }

    protected boolean spawnConstruct(CastContext ctx, Vec3 vec3, @Nullable Direction side) {
        if (!ctx.world().f_46443_) {
            MagicConstructEntity construct = (MagicConstructEntity)((Object)this.constructFactory.apply(ctx.world()));
            construct.m_146884_(vec3);
            if (ctx.caster() != null) {
                construct.setCaster(ctx.caster());
            }
            construct.lifetime = this.permanent ? -1 : (int)((float)this.property(DefaultProperties.DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
            construct.damageMultiplier = ctx.modifiers().get("potency");
            if (construct instanceof ScaledConstructEntity) {
                ScaledConstructEntity scaledConstruct = (ScaledConstructEntity)construct;
                scaledConstruct.setSizeMultiplier(ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()));
            }
            this.addConstructExtras(construct, side, ctx.caster());
            if (!this.allowOverlap && !ctx.world().m_45976_(((Object)((Object)construct)).getClass(), construct.m_20191_()).isEmpty()) {
                return false;
            }
            ctx.world().m_7967_((Entity)construct);
        }
        return true;
    }

    protected void addConstructExtras(T construct, Direction side, @Nullable LivingEntity caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

