/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.data.MinionData;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinionSpell<T extends Mob>
extends Spell {
    public static final String HEALTH_MODIFIER = "minion_health";
    public static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    protected final Function<Level, T> minionFactory;
    protected boolean flying = false;
    protected boolean shouldFollowOwner = true;

    public MinionSpell(Function<Level, T> minionFactory) {
        this.minionFactory = minionFactory;
    }

    public MinionSpell<T> setShouldFollowOwner(boolean shouldFollowOwner) {
        this.shouldFollowOwner = shouldFollowOwner;
        return this;
    }

    public MinionSpell<T> flying(boolean flying) {
        this.flying = flying;
        return this;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!this.extraConditions(ctx, BlockPos.m_274561_((double)ctx.caster().f_19854_, (double)ctx.caster().f_19855_, (double)ctx.caster().f_19856_))) {
            return false;
        }
        if (!this.spawnMinions(ctx)) {
            return false;
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (!this.extraConditions(ctx, BlockPos.m_274561_((double)ctx.caster().f_19854_, (double)ctx.caster().f_19855_, (double)ctx.caster().f_19856_))) {
            return false;
        }
        if (!this.spawnMinions(ctx)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!this.extraConditions(ctx, ctx.pos())) {
            return false;
        }
        if (!ctx.world().f_46443_) {
            for (int i = 0; i < this.property(DefaultProperties.MINION_COUNT); ++i) {
                Mob minion = (Mob)this.minionFactory.apply(ctx.world());
                minion.m_6034_((double)ctx.pos().m_123341_() + 0.5, (double)ctx.pos().m_123342_(), (double)ctx.pos().m_123343_() + 0.5);
                this.setLifetime(minion, (int)(this.property(DefaultProperties.MINION_LIFETIME).floatValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
                this.addMinionExtras(minion, ctx, i);
                ctx.world().m_7967_((Entity)minion);
            }
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected boolean spawnMinions(CastContext ctx) {
        if (ctx.world().f_46443_) {
            return true;
        }
        for (int i = 0; i < this.property(DefaultProperties.MINION_COUNT); ++i) {
            int range = this.property(DefaultProperties.SUMMON_RADIUS);
            BlockPos pos = BlockUtil.findNearbyFloorSpace((Entity)ctx.caster(), range, range * 2);
            if (this.flying) {
                pos = pos != null ? pos.m_175288_(2) : BlockPos.m_274446_((Position)ctx.caster().m_20182_().m_231075_(Direction.NORTH, (double)(ctx.world().f_46441_.m_188503_(range * 2) - range)).m_231075_(Direction.EAST, (double)(ctx.world().f_46441_.m_188503_(range * 2) - range)));
            } else if (pos == null) {
                return false;
            }
            T minion = this.createMinion(ctx.world(), ctx.caster(), ctx.modifiers());
            minion.m_6593_((Component)Component.m_237110_((String)"entity.ebwizardry.minion_name", (Object[])new Object[]{ctx.caster().m_5446_(), minion.m_5446_()}));
            MinionData data = Services.OBJECT_DATA.getMinionData((Mob)minion);
            minion.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            data.setSummoned(true);
            data.setOwnerUUID(ctx.caster().m_20148_());
            this.setLifetime(minion, (int)((float)this.property(DefaultProperties.MINION_LIFETIME).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
            data.setShouldFollowOwner(this.shouldFollowOwner);
            if (minion.m_21051_(Attributes.f_22281_) != null) {
                minion.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(ctx.modifiers().get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (minion.m_21051_(Attributes.f_22276_) != null) {
                minion.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(HEALTH_MODIFIER, (double)(ctx.modifiers().get(HEALTH_MODIFIER) - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            minion.m_21153_(minion.m_21233_());
            minion.m_6518_((ServerLevelAccessor)ctx.world(), ctx.world().m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
            this.addMinionExtras(minion, ctx, i);
            ctx.world().m_7967_(minion);
        }
        return true;
    }

    private void setLifetime(T minion, int lifetime) {
        MinionData data = Services.OBJECT_DATA.getMinionData((Mob)minion);
        data.setLifetime(lifetime);
    }

    protected T createMinion(Level world, @Nullable LivingEntity caster, SpellModifiers modifiers) {
        return (T)((Mob)this.minionFactory.apply(world));
    }

    protected void addMinionExtras(T minion, CastContext ctx, int alreadySpawned) {
    }

    protected boolean extraConditions(CastContext ctx, BlockPos containing) {
        return true;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

