/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.content.entity.projectile.BombEntity;
import com.binaris.wizardry.api.content.entity.projectile.MagicProjectileEntity;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectileSpell<T extends MagicProjectileEntity>
extends Spell {
    private static final float FALLBACK_VELOCITY = 1.5f;
    protected final Function<Level, T> projectileFactory;

    public ProjectileSpell(Function<Level, T> projectileFactory) {
        this.projectileFactory = projectileFactory;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.world().f_46443_) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            projectile.aim((LivingEntity)ctx.caster(), this.calculateVelocity(ctx, projectile, ctx.caster().m_20192_() - 0.3f));
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, (LivingEntity)ctx.caster());
            ctx.world().m_7967_((Entity)projectile);
        }
        ctx.caster().m_6674_(ctx.hand());
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (!ctx.world().f_46443_) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            int aimingError = EntityUtil.getDefaultAimingError(ctx.world().m_46791_());
            projectile.aim(ctx.caster(), (Entity)ctx.target(), this.calculateVelocity(ctx, projectile, ctx.caster().m_20192_() - 0.3f), aimingError);
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, ctx.caster());
            ctx.world().m_7967_((Entity)projectile);
        }
        ctx.caster().m_6674_(ctx.hand());
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!ctx.world().f_46443_) {
            MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)this.projectileFactory.apply(ctx.world()));
            projectile.m_146884_(ctx.vec3());
            Vec3i vec = ctx.direction().m_122436_();
            projectile.m_6686_(vec.m_123341_(), vec.m_123342_(), vec.m_123343_(), this.calculateVelocity(ctx, projectile, 0.375f), 1.0f);
            projectile.damageMultiplier = ctx.modifiers().get("potency");
            if (projectile instanceof BombEntity) {
                BombEntity bomb = (BombEntity)projectile;
                bomb.blastMultiplier = ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            }
            this.addProjectileExtras(projectile, null);
            ctx.world().m_7967_((Entity)projectile);
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected float calculateVelocity(CastContext ctx, MagicProjectileEntity projectile, float launchHeight) {
        float range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        if (projectile.m_20068_()) {
            if (projectile.getLifeTime() <= 0) {
                return 1.5f;
            }
            return range / (float)projectile.getLifeTime();
        }
        float g = 0.05f;
        return range / Mth.m_14116_((float)(2.0f * launchHeight / g));
    }

    protected void addProjectileExtras(T projectile, @Nullable LivingEntity caster) {
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

