/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.abstr;

import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.RayTracer;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class RaySpell
extends Spell {
    protected static final double Y_OFFSET = 0.25;
    protected double particleSpacing = 0.85;
    protected double particleJitter = 0.1;
    protected double particleVelocity = 0.0;
    protected boolean ignoreLivingEntities = false;
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = true;
    protected float aimAssist = 0.0f;

    public Spell particleSpacing(double particleSpacing) {
        this.particleSpacing = particleSpacing;
        return this;
    }

    public Spell particleJitter(double particleJitter) {
        this.particleJitter = particleJitter;
        return this;
    }

    public Spell particleVelocity(double particleVelocity) {
        this.particleVelocity = particleVelocity;
        return this;
    }

    public Spell ignoreLivingEntities(boolean ignoreLivingEntities) {
        this.ignoreLivingEntities = ignoreLivingEntities;
        return this;
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    public Spell aimAssist(float aimAssist) {
        this.aimAssist = aimAssist;
        return this;
    }

    @Override
    public boolean canCastByEntity() {
        return true;
    }

    @Override
    public boolean canCastByLocation() {
        return true;
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        Vec3 look = ctx.caster().m_20154_();
        Vec3 origin = new Vec3(ctx.caster().m_20185_(), ctx.caster().m_20186_() + (double)ctx.caster().m_20192_() - 0.25, ctx.caster().m_20189_());
        if (this.isInstantCast() && ctx.world().f_46443_ && ClientUtils.isFirstPerson((Entity)ctx.caster())) {
            origin = origin.m_82549_(look.m_82490_(1.2));
        }
        if (!this.shootSpell(ctx, origin, look)) {
            return false;
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        Vec3 origin = new Vec3(ctx.caster().m_20185_(), ctx.caster().m_20186_() + (double)ctx.caster().m_20192_() - 0.25, ctx.caster().m_20189_());
        Vec3 targetPos = null;
        if (ctx.target() != null) {
            if (!this.ignoreLivingEntities || !(ctx.target() instanceof LivingEntity)) {
                targetPos = new Vec3(ctx.target().m_20185_(), ctx.target().m_20186_() + (double)(ctx.target().m_20206_() / 2.0f), ctx.target().m_20189_());
            } else {
                int x = Mth.m_14107_((double)ctx.target().m_20185_());
                int y = (int)ctx.target().m_20186_() - 1;
                int z = Mth.m_14107_((double)ctx.target().m_20189_());
                BlockPos pos = new BlockPos(x, y, z);
                if (!(ctx.world().m_46859_(pos) || ctx.world().m_8055_(pos).m_278721_() && !this.hitLiquids)) {
                    targetPos = new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
            }
        }
        if (targetPos == null) {
            return false;
        }
        if (!this.shootSpell(ctx, origin, targetPos.m_82546_(origin).m_82541_())) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        Vec3 vec = new Vec3(ctx.direction().m_253071_());
        if (this.shootSpell(ctx, ctx.vec3(), vec)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    protected abstract boolean onMiss(CastContext var1, Vec3 var2, Vec3 var3);

    protected abstract boolean onBlockHit(CastContext var1, BlockHitResult var2, Vec3 var3);

    protected abstract boolean onEntityHit(CastContext var1, EntityHitResult var2, Vec3 var3);

    protected boolean shootSpell(CastContext ctx, Vec3 origin, Vec3 direction) {
        double range = this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get());
        Vec3 endpoint = origin.m_82549_(direction.m_82490_(range));
        HitResult rayTrace = RayTracer.rayTrace(ctx.world(), (Entity)ctx.caster(), origin, endpoint, this.aimAssist, this.hitLiquids, Entity.class, this.ignoreLivingEntities ? EntityUtil::isLiving : RayTracer.ignoreEntityFilter((Entity)ctx.caster()));
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)rayTrace;
                flag = this.onEntityHit(ctx, entityHit, origin);
                if (flag) {
                    range = origin.m_82554_(rayTrace.m_82450_());
                }
            } else if (rayTrace instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)rayTrace;
                flag = this.onBlockHit(ctx, blockHit, origin);
                range = origin.m_82554_(rayTrace.m_82450_());
            }
        }
        if (!flag && !this.onMiss(ctx, origin, direction)) {
            return false;
        }
        if (ctx.world().f_46443_) {
            this.spawnParticleRay(ctx, origin, direction, range);
        }
        return true;
    }

    protected void spawnParticleRay(CastContext ctx, Vec3 origin, Vec3 direction, double distance) {
        Vec3 velocity = direction.m_82490_(this.particleVelocity);
        for (double d = this.particleSpacing; d <= distance; d += this.particleSpacing) {
            double x = origin.f_82479_ + d * direction.f_82479_ + this.particleJitter * (ctx.world().f_46441_.m_188500_() * 2.0 - 1.0);
            double y = origin.f_82480_ + d * direction.f_82480_ + this.particleJitter * (ctx.world().f_46441_.m_188500_() * 2.0 - 1.0);
            double z = origin.f_82481_ + d * direction.f_82481_ + this.particleJitter * (ctx.world().f_46441_.m_188500_() * 2.0 - 1.0);
            this.spawnParticle(ctx, x, y, z, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
    }
}

