/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.BoulderConstruct;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructSpell;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Boulder
extends ConstructSpell<BoulderConstruct> {
    public static final SpellProperty<Integer> KNOCKBACK_STRENGTH = SpellProperty.intProperty("knockback_strength", 1);
    public static final SpellProperty<Float> SPEED = SpellProperty.floatProperty("speed", 0.44f);

    public Boulder() {
        super(BoulderConstruct::new, false);
    }

    @Override
    protected void addConstructExtras(BoulderConstruct construct, Direction side, @Nullable LivingEntity caster) {
        float speed = this.property(SPEED).floatValue();
        Vec3 direction = caster == null ? new Vec3(side.m_253071_()) : GeometryUtil.horizontalise(caster.m_20154_());
        construct.setHorizontalVelocity(direction.f_82479_ * (double)speed, direction.f_82481_ * (double)speed);
        construct.m_146922_(caster == null ? side.m_122435_() : caster.m_146908_());
        double yOffset = caster == null ? 0.0 : 1.6;
        construct.m_6034_(construct.m_20185_() + direction.f_82479_, construct.m_20186_() + yOffset, construct.m_20189_() + direction.f_82481_);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.EARTH, SpellType.ATTACK, SpellAction.SUMMON, 125, 25, 350).add(DefaultProperties.DURATION, 200).add(DefaultProperties.DAMAGE, Float.valueOf(10.0f)).add(SPEED).add(KNOCKBACK_STRENGTH).build();
    }
}

