/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.blockentity.BlockEntityTimer;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.EBConstants;
import com.binaris.wizardry.setup.registries.EBBlocks;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Cobwebs
extends RaySpell {
    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        boolean flag = false;
        BlockPos pos = blockHit.m_82425_().m_121945_(blockHit.m_82434_());
        int blastUpgradeCount = (int)((ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()) - 1.0f) / EBConstants.RANGE_INCREASE_PER_LEVEL + 0.5f);
        float radius = this.property(DefaultProperties.BLAST_RADIUS).floatValue() + 0.73f * (float)blastUpgradeCount;
        List<BlockPos> sphere = BlockUtil.getBlockSphere(pos, radius);
        for (BlockPos pos1 : sphere) {
            if (!ctx.world().m_46859_(pos1)) continue;
            if (!ctx.world().f_46443_) {
                ctx.world().m_46597_(pos1, EBBlocks.VANISHING_COBWEB.get().m_49966_());
                BlockEntity blockEntity = ctx.world().m_7702_(pos1);
                if (blockEntity instanceof BlockEntityTimer) {
                    BlockEntityTimer timer = (BlockEntityTimer)blockEntity;
                    timer.setLifetime((int)(this.property(DefaultProperties.DURATION).doubleValue() * (double)ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
                }
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        return false;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.EARTH, SpellType.ATTACK, SpellAction.POINT, 30, 0, 70).add(DefaultProperties.RANGE, Float.valueOf(12.0f)).add(DefaultProperties.BLAST_RADIUS, Float.valueOf(1.23f)).add(DefaultProperties.DURATION, 400).build();
    }
}

