/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Fangs
extends Spell {
    private static final double FANG_SPACING = 1.25;

    public static void onHurt(EBLivingHurtEvent event) {
        if (event.getSource().m_7640_() instanceof EvokerFangs && !AllyDesignation.isValidTarget(event.getSource().m_7639_(), (Entity)event.getDamagedEntity())) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (this.spawnFangs(ctx, ctx.caster().m_20182_(), GeometryUtil.horizontalise(ctx.caster().m_20154_()))) {
            return false;
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.target() == null) {
            return false;
        }
        if (this.spawnFangs(ctx, ctx.caster().m_20182_(), ctx.target().m_20182_().m_82546_(ctx.caster().m_20182_()).m_82541_())) {
            return false;
        }
        this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (this.spawnFangs(ctx, ctx.vec3(), Vec3.m_82528_((Vec3i)ctx.direction().m_122436_()))) {
            return false;
        }
        this.playSound(ctx.world(), ctx.vec3(), ctx.castingTicks(), -1);
        return true;
    }

    protected boolean spawnFangs(CastContext ctx, Vec3 origin, Vec3 direction) {
        Player caster;
        LivingEntity livingEntity = ctx.caster();
        boolean defensiveCircle = livingEntity instanceof Player && (caster = (Player)livingEntity).m_6047_() && EBAccessoriesIntegration.isEquipped(caster, EBItems.RING_EVOKER.get());
        boolean flag = false;
        if (ctx.world().f_46443_) {
            double x = origin.f_82479_;
            double y = ctx.caster() != null ? origin.f_82480_ + (double)ctx.caster().m_20192_() : origin.f_82480_;
            double z = origin.f_82481_;
            for (int i = 0; i < 12; ++i) {
                ParticleBuilder.create(EBParticles.DARK_MAGIC, ctx.world().m_213780_(), x, y, z, 0.5, false).color(0.4f, 0.3f, 0.35f).spawn(ctx.world());
            }
        }
        if (defensiveCircle) {
            float yaw;
            for (int i = 0; i < 5; ++i) {
                yaw = (float)i * (float)Math.PI * 0.4f;
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, 0, ctx.caster().m_146892_().m_82520_((double)Mth.m_14089_((float)yaw) * 1.5, 0.0, (double)Mth.m_14031_((float)yaw) * 1.5));
            }
            for (int k = 0; k < 8; ++k) {
                yaw = (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, 3, ctx.caster().m_146892_().m_82520_((double)Mth.m_14089_((float)yaw) * 2.5, 0.0, (double)Mth.m_14031_((float)yaw) * 2.5));
            }
        } else {
            Vec3 horizontal = GeometryUtil.horizontalise(ctx.caster().m_20154_());
            int count = (int)(this.property(DefaultProperties.RANGE).floatValue() * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get()));
            float yaw = (float)Mth.m_14136_((double)horizontal.f_82481_, (double)horizontal.f_82479_);
            for (int i = 0; i < count; ++i) {
                Vec3 vec = ctx.caster().m_146892_().m_82549_(horizontal.m_82490_((double)(i + 1) * 1.25));
                flag |= this.spawnFangsAt(ctx.world(), ctx.caster(), yaw, i, vec);
            }
        }
        return !flag;
    }

    private boolean spawnFangsAt(Level world, LivingEntity caster, float yaw, int delay, Vec3 vec) {
        Integer y = BlockUtil.getNearestFloor(world, BlockPos.m_274446_((Position)vec), 5);
        if (y != null) {
            EvokerFangs fangs = new EvokerFangs(world, vec.f_82479_, (double)y.intValue(), vec.f_82481_, yaw, delay, caster);
            world.m_7967_((Entity)fangs);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.EARTH, SpellType.ATTACK, SpellAction.SUMMON, 40, 5, 60).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

