/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Flight
extends Spell {
    private static final double Y_NUDGE_ACCELERATION = 0.075;

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (ctx.caster().m_20069_() || ctx.caster().m_20077_() || ctx.caster().m_21255_()) {
            return false;
        }
        if (ctx.caster().m_9236_().f_46443_) {
            double x = ctx.caster().f_19854_ - 1.0 + ctx.caster().m_9236_().f_46441_.m_188500_() * 2.0;
            double y = ctx.caster().f_19855_ + (double)ctx.caster().m_20192_() - 0.5 + ctx.caster().m_9236_().f_46441_.m_188500_();
            double z = ctx.caster().f_19856_ - 1.0 + ctx.caster().m_9236_().f_46441_.m_188500_() * 2.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, -0.1, 0.0).time(15).color(0.8f, 1.0f, 0.5f).spawn(ctx.caster().m_9236_());
            x = ctx.caster().f_19854_ - 1.0 + ctx.caster().m_9236_().f_46441_.m_188500_() * 2.0;
            y = ctx.caster().f_19855_ + (double)ctx.caster().m_20192_() - 0.5 + ctx.caster().m_9236_().f_46441_.m_188500_();
            z = ctx.caster().f_19856_ - 1.0 + ctx.caster().m_9236_().f_46441_.m_188500_() * 2.0;
            ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, -0.1, 0.0).time(15).color(1.0f, 1.0f, 1.0f).spawn(ctx.caster().m_9236_());
        }
        if (ctx.castingTicks() % 24 == 0) {
            this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        }
        float potencyModifier = ctx.modifiers().get("potency");
        float speed = this.property(DefaultProperties.SPEED).floatValue() * potencyModifier;
        float acceleration = this.property(DefaultProperties.ACCELERATION).floatValue() * potencyModifier;
        speed = Math.min(speed, 0.7f);
        acceleration = Math.min(acceleration, 0.1f);
        Vec3 currentVelocity = ctx.caster().m_20184_();
        Vec3 lookAngle = ctx.caster().m_20154_();
        double newVelX = currentVelocity.f_82479_;
        double newVelY = currentVelocity.f_82480_;
        double newVelZ = currentVelocity.f_82481_;
        if (Math.abs(lookAngle.f_82479_) > 0.01) {
            double targetVelX = lookAngle.f_82479_ * (double)speed;
            if (Math.abs(currentVelocity.f_82479_) < Math.abs(targetVelX)) {
                newVelX = Math.min(Math.max(currentVelocity.f_82479_ + lookAngle.f_82479_ * (double)acceleration, (double)(-speed)), (double)speed);
            }
        }
        if (Math.abs(lookAngle.f_82481_) > 0.01) {
            double targetVelZ = lookAngle.f_82481_ * (double)speed;
            if (Math.abs(currentVelocity.f_82481_) < Math.abs(targetVelZ)) {
                newVelZ = Math.min(Math.max(currentVelocity.f_82481_ + lookAngle.f_82481_ * (double)acceleration, (double)(-speed)), (double)speed);
            }
        }
        if (Math.abs(lookAngle.f_82480_) > 0.01) {
            double targetVelY = lookAngle.f_82480_ * (double)speed;
            if (Math.abs(currentVelocity.f_82480_) < Math.abs(targetVelY)) {
                double yAcceleration = lookAngle.f_82480_ * (double)acceleration;
                yAcceleration = lookAngle.f_82480_ < 0.0 ? (yAcceleration += 0.1) : (yAcceleration += 0.075);
                newVelY = currentVelocity.f_82480_ + yAcceleration;
                newVelY = Math.min(Math.max(newVelY, (double)(-speed)), (double)speed);
            }
        } else {
            newVelY = Math.min(currentVelocity.f_82480_ + 0.075, (double)speed * 0.5);
        }
        ctx.caster().m_20334_(newVelX, newVelY, newVelZ);
        if (!EBConfig.replaceVanillaFallDamage) {
            ctx.caster().f_19789_ = 0.0f;
        }
        return true;
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.EARTH, SpellType.UTILITY, SpellAction.NONE, 10, 0, 0).add(DefaultProperties.ACCELERATION, Float.valueOf(0.05f)).add(DefaultProperties.SPEED, Float.valueOf(0.5f)).build();
    }
}

