/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ForestsCurse
extends AreaEffectSpell {
    public ForestsCurse() {
        this.alwaysSucceed(true);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, Vec3 origin, LivingEntity target, int targetCount) {
        if (!MagicDamageSource.isEntityImmune(EBDamageSources.POISON, (Entity)target) && !ctx.world().f_46443_) {
            DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.POISON) : target.m_269291_().m_269425_();
            target.m_6469_(source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            int bonusAmplifier = BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"));
            int duration = (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
            int amplifier = this.property(DefaultProperties.EFFECT_STRENGTH) + bonusAmplifier;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, duration, amplifier));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, amplifier));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, amplifier));
        }
        return true;
    }

    @Override
    protected void spawnParticle(Level world, double x, double y, double z) {
        float brightness = world.f_46441_.m_188501_() / 4.0f;
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y += 2.0, z).velocity(0.0, -0.2, 0.0).color(0.05f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        brightness = world.f_46441_.m_188501_() / 4.0f;
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, -0.05, 0.0).time(50).color(0.1f + brightness, 0.2f + brightness, 0.0f).spawn(world);
        ParticleBuilder.create(EBParticles.LEAF).pos(x, y, z).velocity(0.0, -0.01, 0.0).time(40 + world.f_46441_.m_188503_(12)).spawn(world);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.EARTH, SpellType.ATTACK, SpellAction.POINT_UP, 75, 15, 200).add(DefaultProperties.EFFECT_RADIUS, 5).add(DefaultProperties.DAMAGE, Float.valueOf(4.0f)).add(DefaultProperties.EFFECT_DURATION, 140).add(DefaultProperties.EFFECT_STRENGTH, 2).build();
    }
}

