/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Poison
extends RaySpell {
    public Poison() {
        this.particleVelocity(-0.5);
        this.particleSpacing(0.4);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        LivingEntity livingTarget;
        Entity entity = entityHit.m_82443_();
        if (entity instanceof LivingEntity && !MagicDamageSource.isEntityImmune(EBDamageSources.POISON, (Entity)(livingTarget = (LivingEntity)entity)) && !ctx.world().f_46443_) {
            DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.POISON) : livingTarget.m_269291_().m_269425_();
            livingTarget.m_6469_(source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH) + BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"))));
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.3f, 0.7f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().f_46441_.m_188503_(8)).color(0.1f, 0.4f, 0.0f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.EARTH, SpellType.ATTACK, SpellAction.POINT, 10, 0, 20).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(1.0f)).add(DefaultProperties.EFFECT_DURATION, 200).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

