/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.earth;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Whirlwind
extends RaySpell {
    public Whirlwind() {
        this.soundValues(0.8f, 0.7f, 0.2f);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        if (!(ctx instanceof PlayerCastContext)) {
            return false;
        }
        PlayerCastContext playerCtx = (PlayerCastContext)ctx;
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity target = (LivingEntity)entity;
        if (target instanceof Player && !EBConfig.playersMoveEachOther) {
            playerCtx.caster().m_5661_((Component)Component.m_237110_((String)"spell.resist", (Object[])new Object[]{target.m_7755_(), this.getDescriptionId()}), true);
            return false;
        }
        Vec3 vec = target.m_20299_(1.0f).m_82546_(origin).m_82541_();
        if (!ctx.world().f_46443_) {
            float velocity = this.property(DefaultProperties.SPEED).floatValue() * ctx.modifiers().get("potency");
            target.m_20334_(vec.f_82479_ * (double)velocity, vec.f_82480_ * (double)velocity + 1.0, vec.f_82481_ * (double)velocity);
            if (target instanceof ServerPlayer) {
                ((ServerPlayer)target).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target));
            }
        } else {
            double distance = Math.sqrt(target.m_20275_(origin.f_82479_, origin.f_82480_, origin.f_82481_));
            for (int i = 0; i < 10; ++i) {
                double t = ctx.world().f_46441_.m_188500_();
                double x = origin.f_82479_ + vec.f_82479_ * distance * t + (ctx.world().f_46441_.m_188500_() - 0.5) * 0.3;
                double y = origin.f_82480_ + vec.f_82480_ * distance * t + (ctx.world().f_46441_.m_188500_() - 0.5) * 0.3;
                double z = origin.f_82481_ + vec.f_82481_ * distance * t + (ctx.world().f_46441_.m_188500_() - 0.5) * 0.3;
                ctx.world().m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, vec.f_82479_ * 0.3, vec.f_82480_ * 0.3, vec.f_82481_ * 0.3);
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    public boolean canCastByEntity() {
        return false;
    }

    @Override
    public boolean canCastByLocation() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.EARTH, SpellType.DEFENCE, SpellAction.POINT, 10, 0, 15).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.SPEED, Float.valueOf(1.5f)).build();
    }
}

