/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.fire;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.DrawingUtils;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Firestorm
extends AreaEffectSpell {
    public Firestorm() {
        this.soundValues(2.0f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.caster().m_20182_());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.caster().m_20182_());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        this.burnNearbyBlocks(ctx, ctx.vec3());
        return super.cast(ctx);
    }

    @Override
    public SpellAction getAction() {
        return SpellAction.POINT_DOWN;
    }

    @Override
    public int getCharge() {
        return 20;
    }

    @Override
    protected boolean affectEntity(CastContext ctx, Vec3 origin, LivingEntity target, int targetCount) {
        if (!MagicDamageSource.isEntityImmune(EBDamageSources.FIRE, (Entity)target)) {
            target.m_20254_(this.property(DefaultProperties.EFFECT_DURATION).intValue());
        }
        return true;
    }

    private void burnNearbyBlocks(CastContext ctx, Vec3 origin) {
        if (ctx.world().f_46443_ || !EntityUtil.canDamageBlocks(ctx.caster(), ctx.world())) {
            return;
        }
        double radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        for (int i = -((int)radius); i <= (int)radius; ++i) {
            for (int j = -((int)radius); j <= (int)radius; ++j) {
                BlockPos pos = new BlockPos((int)origin.m_7096_(), (int)origin.m_7098_(), (int)origin.m_7094_()).m_7918_(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(ctx.world(), new BlockPos((Vec3i)pos), Direction.UP, (int)radius, true, BlockUtil.SurfaceCriteria.NOT_AIR_TO_AIR);
                if (y == null) continue;
                pos = new BlockPos(pos.m_123341_(), y.intValue(), pos.m_123343_());
                double dist = origin.m_82554_(new Vec3(origin.f_82479_ + (double)i, (double)y.intValue(), origin.f_82481_ + (double)j));
                if (y == -1 || !((double)ctx.world().f_46441_.m_188503_((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !(dist > 1.5) || !BlockUtil.canPlaceBlock(ctx.caster(), ctx.world(), pos)) continue;
                ctx.world().m_46597_(pos, Blocks.f_50083_.m_49966_());
            }
        }
    }

    @Override
    protected void spawnParticleEffect(CastContext ctx, Vec3 origin, double radius) {
        double speed;
        float r;
        int i;
        for (i = 0; i < 100; ++i) {
            r = ctx.world().f_46441_.m_188501_();
            speed = 0.02 / (double)r * (1.0 + ctx.world().f_46441_.m_188500_());
            ParticleBuilder.create(EBParticles.MAGIC_FIRE).pos(origin.f_82479_, origin.f_82480_ + ctx.world().f_46441_.m_188500_() * 3.0, origin.f_82481_).velocity(0.0, 0.0, 0.0).scale(2.0f).time(40 + ctx.world().f_46441_.m_188503_(10)).spin(ctx.world().f_46441_.m_188500_() * (radius - 0.5) + 0.5, speed).spawn(ctx.world());
        }
        for (i = 0; i < 60; ++i) {
            r = ctx.world().f_46441_.m_188501_();
            speed = 0.02 / (double)r * (1.0 + ctx.world().f_46441_.m_188500_());
            ParticleBuilder.create(EBParticles.CLOUD).pos(origin.f_82479_, origin.f_82480_ + ctx.world().f_46441_.m_188500_() * 2.5, origin.f_82481_).color(DrawingUtils.mix(DrawingUtils.mix(16760320, 16725504, r / 0.6f), 0x222222, (r - 0.6f) / 0.4f)).spin((double)r * (radius - 1.0) + 0.5, speed).spawn(ctx.world());
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.FIRE, SpellType.ATTACK, SpellAction.POINT_DOWN, 80, 20, 250).add(DefaultProperties.EFFECT_RADIUS, 6).add(DefaultProperties.EFFECT_DURATION, 15).build();
    }
}

