/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.fire;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.entity.MeteorEntity;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Meteor
extends RaySpell {
    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!EBAccessoriesIntegration.isEquipped(ctx.caster(), EBItems.RING_METEOR.get())) {
            return super.cast(ctx);
        }
        if (!ctx.world().f_46443_) {
            MeteorEntity meteor = new MeteorEntity(ctx.world(), ctx.caster().m_20185_(), ctx.caster().m_20186_() + (double)ctx.caster().m_20192_(), ctx.caster().m_20189_(), ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()), EntityUtil.canDamageBlocks((LivingEntity)ctx.caster(), ctx.world()));
            Vec3 direction = ctx.caster().m_20154_().m_82490_((double)(2.0f * ctx.modifiers().get(EBItems.RANGE_UPGRADE.get())));
            meteor.m_20256_(direction);
            ctx.world().m_7967_((Entity)meteor);
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        if (ctx.world().m_45527_(blockHit.m_82425_().m_7494_())) {
            if (!ctx.world().f_46443_) {
                MeteorEntity meteor = new MeteorEntity(ctx.world(), blockHit.m_82425_().m_123341_(), blockHit.m_82425_().m_123342_() + 50, blockHit.m_82425_().m_123343_(), ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()), EntityUtil.canDamageBlocks(ctx.caster(), ctx.world()));
                ctx.world().m_7967_((Entity)meteor);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        return false;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.FIRE, SpellType.ATTACK, SpellAction.POINT, 100, 20, 200).add(DefaultProperties.RANGE, Float.valueOf(40.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(2.0f)).build();
    }
}

