/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.fire;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.InventoryUtil;
import com.binaris.wizardry.core.EBConfig;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PocketFurnace
extends Spell {
    public static final SpellProperty<Integer> ITEMS_SMELTED = SpellProperty.intProperty("items_smelted");

    public PocketFurnace() {
        this.soundValues(1.0f, 1.0f, 0.2f);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        ItemStack result;
        Optional optionalSmeltingRecipe;
        SimpleContainer dummyInv;
        ItemStack stack;
        int i;
        int usesLeft = (int)((float)this.property(ITEMS_SMELTED).intValue() * ctx.modifiers().get("potency"));
        boolean itemsSmelted = false;
        boolean hasSmeltableItems = false;
        for (i = 0; i < ctx.caster().m_150109_().m_6643_(); ++i) {
            stack = ctx.caster().m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            dummyInv = new SimpleContainer(1);
            dummyInv.m_6836_(0, stack);
            optionalSmeltingRecipe = ctx.world().m_7465_().m_44015_(RecipeType.f_44108_, (Container)dummyInv, ctx.caster().m_9236_());
            if (optionalSmeltingRecipe.isEmpty() || (result = ((SmeltingRecipe)optionalSmeltingRecipe.get()).m_8043_(null)).m_41619_() || stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ArmorItem || EBConfig.isOnList(EBConfig.meltItemsBlackList, stack)) continue;
            hasSmeltableItems = true;
            break;
        }
        if (!hasSmeltableItems) {
            return false;
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        if (ctx.world().f_46443_) {
            for (i = 0; i < 10; ++i) {
                double x1 = (float)ctx.caster().m_20182_().f_82479_ + ctx.world().f_46441_.m_188501_() * 2.0f - 1.0f;
                double y1 = (float)ctx.caster().m_20182_().f_82480_ + ctx.caster().m_20192_() - 0.5f + ctx.world().f_46441_.m_188501_();
                double z1 = (float)ctx.caster().m_20182_().f_82481_ + ctx.world().f_46441_.m_188501_() * 2.0f - 1.0f;
                ctx.world().m_7106_((ParticleOptions)ParticleTypes.f_123744_, x1, y1, z1, 0.0, (double)0.01f, 0.0);
            }
        } else {
            for (i = 0; i < ctx.caster().m_150109_().m_6643_() && usesLeft > 0; ++i) {
                stack = ctx.caster().m_150109_().m_8020_(i);
                if (stack.m_41619_()) continue;
                dummyInv = new SimpleContainer(1);
                dummyInv.m_6836_(0, stack);
                optionalSmeltingRecipe = ctx.world().m_7465_().m_44015_(RecipeType.f_44108_, (Container)dummyInv, ctx.caster().m_9236_());
                if (optionalSmeltingRecipe.isEmpty()) continue;
                ((SmeltingRecipe)optionalSmeltingRecipe.get()).m_5874_((Container)dummyInv, null);
                result = ((SmeltingRecipe)optionalSmeltingRecipe.get()).m_8043_(null);
                if (result.m_41619_() || stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ArmorItem || EBConfig.isOnList(EBConfig.meltItemsBlackList, stack)) continue;
                if (stack.m_41613_() <= usesLeft) {
                    ItemStack stack2 = new ItemStack((ItemLike)result.m_41720_(), stack.m_41613_());
                    if (InventoryUtil.doesPlayerHaveItem(ctx.caster(), result.m_41720_())) {
                        ctx.caster().m_36356_(stack2);
                        ctx.caster().m_150109_().m_6836_(i, ItemStack.f_41583_);
                    } else {
                        ctx.caster().m_150109_().m_6836_(i, stack2);
                    }
                    usesLeft -= stack.m_41613_();
                    itemsSmelted = true;
                    continue;
                }
                ItemStack copy = ctx.caster().m_150109_().m_8020_(i).m_41777_();
                copy.m_41774_(usesLeft);
                ctx.caster().m_150109_().m_6836_(i, copy);
                ctx.caster().m_150109_().m_36054_(new ItemStack((ItemLike)result.m_41720_(), usesLeft));
                usesLeft = 0;
                itemsSmelted = true;
            }
        }
        return itemsSmelted;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.FIRE, SpellType.UTILITY, SpellAction.IMBUE, 30, 0, 40).add(ITEMS_SMELTED, 5).build();
    }
}

