/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.healing;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HealAlly
extends RaySpell {
    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        Entity entity = entityHit.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target.m_21223_() < target.m_21233_() && target.m_21223_() > 0.0f) {
                target.m_5634_(this.property(DefaultProperties.HEALTH).floatValue() * ctx.modifiers().get("potency"));
                if (ctx.world().f_46443_) {
                    ParticleBuilder.spawnHealParticles(ctx.world(), target);
                }
                this.playSound(ctx.world(), target, 0, -1);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.HEALING, SpellType.DEFENCE, SpellAction.POINT, 10, 0, 20).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.HEALTH, Float.valueOf(5.0f)).build();
    }
}

