/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.healing;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InvigoratingPresence
extends AreaEffectSpell {
    public InvigoratingPresence() {
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.alwaysSucceed(true);
        this.targetAllies(true);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, Vec3 origin, LivingEntity target, int targetCount) {
        int bonusAmplifier = BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"));
        if (!ctx.world().f_46443_) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH) + bonusAmplifier));
        }
        return false;
    }

    @Override
    protected void spawnParticle(Level world, double x, double y, double z) {
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(0.0, 0.03, 0.0).time(50).color(1.0f, 0.2f, 0.2f).spawn(world);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.HEALING, SpellType.BUFF, SpellAction.POINT_UP, 30, 0, 60).add(DefaultProperties.EFFECT_RADIUS, 5).add(DefaultProperties.EFFECT_DURATION, 900).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

