/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.healing;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.client.util.ClientUtils;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RayOfPurification
extends RaySpell {
    private static final SpellProperty<Float> UNDEAD_DAMAGE_MULTIPLIER = SpellProperty.floatProperty("undead_damage_multiplier", 2.0f);

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity target = (LivingEntity)entity;
        if (MagicDamageSource.isEntityImmune(EBDamageSources.RADIANT, (Entity)target)) {
            if (!ctx.world().m_5776_() && ctx.castingTicks() == 1) {
                ctx.caster().m_213846_((Component)Component.m_237110_((String)"spell.resist", (Object[])new Object[]{target.m_7755_(), this.getDescriptionFormatted()}));
            }
            return false;
        }
        if (ctx.castingTicks() % 10 != 0) {
            return true;
        }
        float damage = this.property(UNDEAD_DAMAGE_MULTIPLIER).floatValue() * ctx.modifiers().get("potency");
        if (target.m_21222_()) {
            damage *= this.property(UNDEAD_DAMAGE_MULTIPLIER).floatValue();
        }
        EntityUtil.attackEntityWithoutKnockback((Entity)target, MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.RADIANT), damage);
        if (!ctx.world().f_46443_) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()))));
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected void playSound(Level world, LivingEntity entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(Level world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected void spawnParticleRay(CastContext ctx, Vec3 origin, Vec3 direction, double distance) {
        if (ctx.caster() != null) {
            ParticleBuilder.create(EBParticles.BEAM).entity((Entity)ctx.caster()).pos(origin.m_82546_(ctx.caster().m_20182_())).length(distance).color(1.0f, 0.6f + 0.3f * ctx.world().f_46441_.m_188501_(), 0.2f).scale((float)(Math.sin((float)ctx.caster().f_19797_ * 0.2f) * (double)0.1f + (double)1.4f)).spawn(ctx.world());
        } else {
            ParticleBuilder.create(EBParticles.BEAM).pos(origin).target(origin.m_82549_(direction.m_82490_(distance))).color(1.0f, 0.6f + 0.3f * ctx.world().f_46441_.m_188501_(), 0.2f).scale((float)(Math.sin((float)ClientUtils.getPlayer().f_19797_ * 0.2f) * (double)0.1f + (double)1.4f)).spawn(ctx.world());
        }
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.HEALING, SpellType.ATTACK, SpellAction.POINT, 10, 10, 40).add(DefaultProperties.DAMAGE, Float.valueOf(2.0f)).add(DefaultProperties.EFFECT_DURATION, 100).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(UNDEAD_DAMAGE_MULTIPLIER).build();
    }
}

