/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Freeze
extends RaySpell {
    public Freeze() {
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.hitLiquids(true);
        this.ignoreUncollidables(false);
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        if (!ctx.world().f_46443_ && BlockUtil.canPlaceBlock(ctx.caster(), ctx.world(), blockHit.m_82425_())) {
            BlockUtil.freeze(ctx.world(), blockHit.m_82425_(), true);
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        LivingEntity target;
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity) || MagicDamageSource.isEntityImmune(EBDamageSources.FROST, (Entity)(target = (LivingEntity)entity))) {
            return false;
        }
        if (target instanceof Blaze || target instanceof MagmaCube) {
            DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.FROST) : target.m_269291_().m_269425_();
            target.m_6469_(source, this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
        }
        if (ctx.world().f_46443_) {
            return true;
        }
        target.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        if (target.m_6060_()) {
            target.m_20095_();
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = 0.5f + ctx.world().f_46441_.m_188501_() / 2.0f;
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().f_46441_.m_188503_(8)).color(brightness, brightness + 0.1f, 1.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SNOW).pos(x, y, z).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.NOVICE, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 5, 0, 10).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(3.0f)).add(DefaultProperties.EFFECT_DURATION, 200).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

