/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.IceBarrierConstruct;
import com.binaris.wizardry.setup.registries.EBEntities;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FrostBarrier
extends Spell {
    private static final double BARRIER_DISTANCE = 2.0;
    private static final double BARRIER_ARC_RADIUS = 10.0;
    private static final double BARRIER_SPACING = 1.4;

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (ctx.caster().m_20096_()) {
            if (!this.createBarriers(ctx.world(), ctx.caster().m_20182_(), ctx.caster().m_20154_(), (LivingEntity)ctx.caster())) {
                return false;
            }
            this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        if (ctx.caster().m_20096_()) {
            if (!this.createBarriers(ctx.world(), ctx.caster().m_20182_(), ctx.target().m_20182_().m_82546_(ctx.caster().m_20182_()), ctx.caster())) {
                return false;
            }
            this.playSound(ctx.world(), ctx.caster(), ctx.castingTicks(), -1);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        if (!this.createBarriers(ctx.world(), ctx.vec3(), new Vec3(ctx.direction().m_253071_()), null)) {
            return false;
        }
        this.playSound(ctx.world(), ctx.x() - (double)ctx.direction().m_122429_(), ctx.y() - (double)ctx.direction().m_122430_(), ctx.z() - (double)ctx.direction().m_122431_(), ctx.castingTicks(), ctx.duration());
        return true;
    }

    private boolean createBarriers(Level world, Vec3 origin, Vec3 direction, @Nullable LivingEntity caster) {
        if (!world.f_46443_) {
            direction = GeometryUtil.horizontalise(direction);
            Vec3 centre = origin.m_82549_(direction.m_82490_(-8.0));
            ArrayList<IceBarrierConstruct> barriers = new ArrayList<IceBarrierConstruct>();
            int barrierCount = 3;
            for (int i = 0; i < barrierCount; ++i) {
                IceBarrierConstruct barrier = this.createBarrier(world, centre, direction.m_82524_(0.14f * (float)i), caster, barrierCount, i);
                if (barrier != null) {
                    barriers.add(barrier);
                }
                if (i == 0 || (barrier = this.createBarrier(world, centre, direction.m_82524_(-0.14f * (float)i), caster, barrierCount, i)) == null) continue;
                barriers.add(barrier);
            }
            if (barriers.isEmpty()) {
                return false;
            }
            barriers.forEach(arg_0 -> ((Level)world).m_7967_(arg_0));
        }
        return true;
    }

    private IceBarrierConstruct createBarrier(Level world, Vec3 centre, Vec3 direction, @Nullable LivingEntity caster, int barrierCount, int index) {
        Vec3 position = centre.m_82549_(direction.m_82490_(10.0));
        Integer floor = BlockUtil.getNearestFloor(world, BlockPos.m_274446_((Position)position), 3);
        if (floor == null) {
            return null;
        }
        position = GeometryUtil.replaceComponent(position, Direction.Axis.Y, floor.intValue());
        float scale = 1.5f - (float)index / (float)barrierCount * 0.5f;
        double yOffset = 1.5 * (double)scale;
        IceBarrierConstruct barrier = new IceBarrierConstruct(EBEntities.ICE_BARRIER.get(), world);
        barrier.m_6034_(position.f_82479_, position.f_82480_ - yOffset, position.f_82481_);
        barrier.setCaster(caster);
        barrier.lifetime = 400;
        barrier.damageMultiplier = 1.0f;
        barrier.m_19915_((float)Math.toDegrees(Mth.m_14136_((double)(-direction.f_82479_), (double)direction.f_82481_)), barrier.m_146909_());
        barrier.setSizeMultiplier(scale);
        barrier.setDelay(1 + 3 * index);
        if (!world.m_45976_(barrier.getClass(), barrier.m_20191_().m_82386_(0.0, yOffset, 0.0)).isEmpty()) {
            return null;
        }
        return barrier;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.empty();
    }
}

