/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.Objects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FrostRay
extends RaySpell {
    public FrostRay() {
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        LivingEntity target;
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity) || MagicDamageSource.isEntityImmune(EBDamageSources.FROST, (Entity)(target = (LivingEntity)entity))) {
            return false;
        }
        if (target.m_6060_()) {
            target.m_20095_();
        }
        if (ctx.world().f_46443_) {
            return true;
        }
        target.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), this.property(DefaultProperties.EFFECT_DURATION).intValue(), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        int n = ctx.castingTicks();
        Objects.requireNonNull(target);
        if (n % 20 == 1) {
            float damage = this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency");
            if (target instanceof Blaze || target instanceof MagmaCube) {
                damage *= 2.0f;
            }
            DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.FROST) : target.m_269291_().m_269425_();
            EntityUtil.attackEntityWithoutKnockback((Entity)target, source, damage);
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    public int getCharge() {
        return 20;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = ctx.world().f_46441_.m_188501_();
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().f_46441_.m_188503_(12)).color(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).collide(true).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SNOW).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().f_46441_.m_188503_(12)).collide(true).spawn(ctx.world());
    }

    @Override
    protected void playSound(Level world, LivingEntity entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(Level world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 5, 0, 0).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(3.0f)).add(DefaultProperties.EFFECT_DURATION, 200).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

