/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.LocationCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceAge
extends AreaEffectSpell {
    private static final SpellProperty<Integer> FREEZE_DURATION = SpellProperty.intProperty("freeze_duration", 1200);

    public IceAge() {
        this.soundValues(1.5f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.caster().m_20182_(), (LivingEntity)ctx.caster(), ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(LocationCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.vec3(), null, ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        this.freezeNearbyBlocks(ctx.world(), ctx.caster().m_20182_(), ctx.caster(), ctx.modifiers());
        return super.cast(ctx);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, Vec3 origin, LivingEntity target, int targetCount) {
        target.m_7292_(new MobEffectInstance(EBMobEffects.FROST.get(), (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH).intValue()));
        target.m_5496_(EBSounds.MISC_FREEZE.get(), 1.0f, ctx.world().f_46441_.m_188501_() * 0.4f + 0.8f);
        return true;
    }

    @Override
    protected void spawnParticleEffect(CastContext ctx, Vec3 origin, double radius) {
        double speed;
        float r;
        int i;
        RandomSource random = ctx.world().f_46441_;
        for (i = 0; i < 100; ++i) {
            r = random.m_188501_();
            speed = 0.02 / (double)r * (1.0 + random.m_188500_());
            ParticleBuilder.create(EBParticles.SNOW).pos(origin.f_82479_, origin.f_82480_ + random.m_188500_() * 3.0, origin.f_82481_).velocity(0.0, 0.0, 0.0).spin(random.m_188500_() * (radius - 0.5) + 0.5, speed).shaded(true).scale(2.0f).spawn(ctx.world());
        }
        for (i = 0; i < 60; ++i) {
            r = random.m_188501_();
            speed = 0.02 / (double)r * (1.0 + random.m_188500_());
            ParticleBuilder.create(EBParticles.CLOUD).pos(origin.f_82479_, origin.f_82480_ + random.m_188500_() * 2.5, origin.f_82481_).spin(random.m_188500_() * (radius - 1.0) + 0.5, speed).color(0xFFFFFF).shaded(true).spawn(ctx.world());
        }
    }

    private void freezeNearbyBlocks(Level world, Vec3 origin, @Nullable LivingEntity caster, SpellModifiers modifiers) {
        if (world.m_5776_() || !EntityUtil.canDamageBlocks(caster, world)) {
            return;
        }
        double radius = this.property(DefaultProperties.EFFECT_RADIUS).floatValue() * modifiers.get(EBItems.BLAST_UPGRADE.get());
        for (int i = -((int)radius); i <= (int)radius; ++i) {
            for (int j = -((int)radius); j <= (int)radius; ++j) {
                BlockPos pos = BlockPos.m_274446_((Position)origin).m_7918_(i, 0, j);
                Integer y = BlockUtil.getNearestSurface(world, new BlockPos((Vec3i)pos), Direction.UP, (int)radius, true, BlockUtil.SurfaceCriteria.SOLID_LIQUID_TO_AIR);
                if (y == null) continue;
                pos = new BlockPos(pos.m_123341_(), y.intValue(), pos.m_123343_());
                double dist = origin.m_82554_(new Vec3(origin.f_82479_ + (double)i, (double)y.intValue(), origin.f_82481_ + (double)j));
                if (y == -1 || !((double)world.f_46441_.m_188503_((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !BlockUtil.canPlaceBlock(caster, world, pos)) continue;
                BlockUtil.freeze(world, pos.m_7495_(), true);
            }
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.ICE, SpellType.ATTACK, SpellAction.POINT_DOWN, 70, 20, 250).add(DefaultProperties.EFFECT_RADIUS, 7).add(FREEZE_DURATION).add(DefaultProperties.EFFECT_DURATION, 400).add(DefaultProperties.EFFECT_STRENGTH, 1).build();
    }
}

