/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.ice;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.api.content.util.GeometryUtil;
import com.binaris.wizardry.content.entity.construct.IceSpikeConstruct;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructRangedSpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IceSpickes
extends ConstructRangedSpell<IceSpikeConstruct> {
    public IceSpickes() {
        super(IceSpikeConstruct::new, true);
        this.ignoreUncollidables(true);
    }

    @Override
    protected boolean spawnConstruct(CastContext ctx, Vec3 origin, @Nullable Direction side) {
        if (side == null) {
            return false;
        }
        BlockPos blockHit = BlockPos.m_274446_((Position)origin);
        if (side.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            blockHit = blockHit.m_121945_(side);
        }
        if (ctx.world().m_8055_(blockHit).m_60838_((BlockGetter)ctx.world(), blockHit)) {
            return false;
        }
        Vec3 pos = origin.m_82549_(new Vec3(side.m_122424_().m_253071_()));
        super.spawnConstruct(ctx, pos, side);
        int quantity = (int)((float)Spells.ICE_SPICKES.property(DefaultProperties.ENTITIES).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get()) - 1.0f);
        float maxRadius = (float)Spells.ICE_SPICKES.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        for (int i = 0; i < quantity; ++i) {
            Integer surface;
            double radius = 0.5 + ctx.world().f_46441_.m_188500_() * ((double)maxRadius - 0.5);
            Vec3 offset = Vec3.m_82498_((float)(ctx.world().f_46441_.m_188501_() * 180.0f - 90.0f), (float)(ctx.world().f_46441_.m_188499_() ? 0.0f : 180.0f)).m_82490_(radius).m_82524_(side.m_122435_() * (float)Math.PI / 180.0f).m_82496_(GeometryUtil.getPitch(side) * (float)Math.PI / 180.0f);
            if (side.m_122434_().m_122479_()) {
                offset = offset.m_82524_(1.5707964f);
            }
            if ((surface = BlockUtil.getNearestSurface(ctx.world(), new BlockPos((Vec3i)BlockPos.m_274446_((Position)origin.m_82549_(offset))), side, (int)maxRadius, true, BlockUtil.SurfaceCriteria.basedOn(this::isCollisionShapeFullBlock))) == null) continue;
            Vec3 vec = GeometryUtil.replaceComponent(origin.m_82549_(offset), side.m_122434_(), surface.intValue()).m_82546_(new Vec3(side.m_253071_()));
            super.spawnConstruct(ctx, vec, side);
        }
        return true;
    }

    public boolean isCollisionShapeFullBlock(BlockGetter blockGetter, BlockPos pos) {
        return blockGetter.m_8055_(pos).m_60838_(blockGetter, pos);
    }

    @Override
    protected void addConstructExtras(IceSpikeConstruct construct, Direction side, @Nullable LivingEntity caster) {
        construct.lifetime = 30 + construct.m_9236_().f_46441_.m_188503_(15);
        construct.setFacing(side);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.ICE, SpellType.ATTACK, SpellAction.POINT, 30, 0, 75).add(DefaultProperties.RANGE, Float.valueOf(20.0f)).add(DefaultProperties.EFFECT_RADIUS, 3).add(DefaultProperties.ENTITIES, 18).add(DefaultProperties.DAMAGE, Float.valueOf(5.0f)).add(DefaultProperties.EFFECT_DURATION, 100).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

