/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.lightning;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Arc
extends RaySpell {
    public Arc() {
        this.aimAssist(0.6f);
        this.soundValues(1.0f, 1.7f, 0.2f);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity target = (LivingEntity)entity;
        if (ctx.world().f_46443_) {
            ParticleBuilder.create(EBParticles.LIGHTNING).entity((Entity)ctx.caster()).pos(ctx.caster() != null ? origin.m_82546_(ctx.caster().m_20182_()) : origin).target((Entity)target).spawn(ctx.world());
            ParticleBuilder.spawnShockParticles(ctx.world(), target.f_19854_, target.f_19855_ + (double)(target.m_20206_() / 2.0f), target.f_19856_);
        }
        if (MagicDamageSource.isEntityImmune(EBDamageSources.SHOCK, (Entity)target)) {
            LivingEntity livingEntity;
            if (!ctx.world().f_46443_ && (livingEntity = ctx.caster()) instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_5661_((Component)Component.m_237110_((String)"spell.resist", (Object[])new Object[]{target.m_7755_(), this.getDescriptionFormatted()}), true);
            }
        } else {
            target.m_6469_(MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.SHOCK), this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.NOVICE, Elements.LIGHTNING, SpellType.ATTACK, SpellAction.POINT, 5, 0, 15).add(DefaultProperties.RANGE, Float.valueOf(3.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.SENSIBLE, true).build();
    }
}

