/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.lightning;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.ISpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.Spells;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Charge
extends Spell {
    public static final ISpellVar<SpellModifiers> CHARGE_MODIFIERS = new ISpellVar.SpellVar<SpellModifiers>(Persistence.NEVER);
    public static final SpellProperty<Float> CHARGE_SPEED = SpellProperty.floatProperty("charge_speed");
    public static final ISpellVar<Integer> CHARGE_TIME = new ISpellVar.SpellVar<Integer>(Persistence.NEVER).withTicker(Charge::update);

    public Charge() {
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    private static int update(Player player, Integer chargeTime) {
        if (chargeTime == null) {
            chargeTime = 0;
        }
        if (chargeTime > 0 && !player.m_9236_().f_46443_) {
            SpellModifiers modifiers = Services.OBJECT_DATA.getSpellManagerData(player).getVariable(CHARGE_MODIFIERS);
            if (modifiers == null) {
                modifiers = new SpellModifiers();
            }
            Vec3 look = player.m_20154_();
            float speed = Spells.CHARGE.property(CHARGE_SPEED).floatValue() * modifiers.get(EBItems.RANGE_UPGRADE.get());
            player.m_20334_(look.f_82479_ * (double)speed, player.m_20184_().f_82480_, look.f_82481_ * (double)speed);
            if (player.m_9236_().f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create(EBParticles.SPARK, (Entity)player).spawn(player.m_9236_());
                }
            }
            List collided = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(1.0));
            collided.remove(player);
            float damage = Spells.CHARGE.property(DefaultProperties.DAMAGE).floatValue() * modifiers.get("potency");
            float knockback = Spells.CHARGE.property(DefaultProperties.KNOCKBACK).floatValue();
            collided.forEach(e -> e.m_6469_(MagicDamageSource.causeDirectMagicDamage((Entity)player, EBDamageSources.SHOCK), damage));
            collided.forEach(e -> e.m_5997_(player.m_20184_().f_82479_ * (double)knockback, player.m_20184_().f_82480_ * (double)knockback + (double)0.3f, player.m_20184_().f_82481_ * (double)knockback));
            if (player.m_9236_().f_46443_) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, player.m_20185_() + player.m_20184_().f_82479_, player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_() + player.m_20184_().f_82481_, 0.0, 0.0, 0.0);
            }
            if (collided.isEmpty()) {
                Integer n = chargeTime;
                chargeTime = chargeTime - 1;
            } else {
                EntityUtil.playSoundAtPlayer(player, SoundEvents.f_11915_, 1.0f, 1.0f);
                chargeTime = 0;
            }
            player.f_19864_ = true;
        }
        return chargeTime;
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity livingEntity = event.getDamagedEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getSource().m_7639_();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity attacker = livingEntity;
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(player);
                Integer chargeTime = data.getVariable(CHARGE_TIME);
                if (chargeTime != null && chargeTime > 0 && player.m_20191_().m_82400_(1.0).m_82381_(attacker.m_20191_())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean cast(PlayerCastContext ctx) {
        SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(ctx.caster());
        data.setVariable(CHARGE_TIME, (int)(this.property(DefaultProperties.DURATION).floatValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())));
        data.setVariable(CHARGE_MODIFIERS, ctx.modifiers());
        if (ctx.world().f_46443_) {
            ctx.world().m_7106_((ParticleOptions)ParticleTypes.f_123812_, ctx.caster().m_20185_(), ctx.caster().m_20186_() + (double)(ctx.caster().m_20206_() / 2.0f), ctx.caster().m_20189_(), 0.0, 0.0, 0.0);
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.LIGHTNING, SpellType.ATTACK, SpellAction.POINT, 20, 0, 50).add(CHARGE_SPEED, Float.valueOf(2.0f)).add(DefaultProperties.DURATION, 10).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.KNOCKBACK, Float.valueOf(1.0f)).build();
    }
}

