/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.lightning;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.core.AllyDesignation;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class LightningPulse
extends Spell {
    private static final SpellProperty<Float> REPULSION_VELOCITY = SpellProperty.floatProperty("repulsion_velocity", 0.8f);

    @Override
    public boolean cast(PlayerCastContext ctx) {
        if (!ctx.caster().m_20096_()) {
            return false;
        }
        float radius = (float)this.property(DefaultProperties.EFFECT_RADIUS).intValue() * ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
        List<LivingEntity> targets = EntityUtil.getLivingWithinRadius(radius, ctx.caster().m_20185_(), ctx.caster().m_20186_(), ctx.caster().m_20189_(), ctx.world());
        targets.removeIf(t -> !AllyDesignation.isValidTarget((Entity)ctx.caster(), (Entity)t));
        for (LivingEntity target : targets) {
            target.m_6469_(MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.SHOCK), this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            if (ctx.world().m_5776_()) continue;
            double dx = target.m_20185_() - ctx.caster().m_20185_();
            double dz = target.m_20189_() - ctx.caster().m_20189_();
            double vectorLength = Math.sqrt(dx * dx + dz * dz);
            target.m_20334_((double)this.property(REPULSION_VELOCITY).floatValue() * (dx /= vectorLength), 0.0, (double)this.property(REPULSION_VELOCITY).floatValue() * (dz /= vectorLength));
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target));
        }
        if (ctx.world().m_5776_()) {
            ParticleBuilder.create(EBParticles.LIGHTNING_PULSE).pos(ctx.caster().m_20185_(), ctx.caster().m_20186_() + 0.005, ctx.caster().m_20189_()).scale(ctx.modifiers().get(EBItems.BLAST_UPGRADE.get())).spawn(ctx.world());
        }
        this.playSound(ctx.world(), (LivingEntity)ctx.caster(), ctx.castingTicks(), -1);
        return true;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.LIGHTNING, SpellType.ATTACK, SpellAction.POINT_DOWN, 25, 0, 75).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.EFFECT_RADIUS, 3).add(REPULSION_VELOCITY).add(DefaultProperties.SENSIBLE, true).build();
    }
}

