/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Banish
extends RaySpell {
    public static final SpellProperty<Integer> MINIMUM_TELEPORT = SpellProperty.intProperty("minimum_teleport_distance", 8);
    public static final SpellProperty<Integer> MAX_TELEPORT = SpellProperty.intProperty("maximum_teleport_distance", 16);

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        Entity entity = entityHit.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            double minRadius = this.property(MINIMUM_TELEPORT).intValue();
            double maxRadius = this.property(MAX_TELEPORT).intValue();
            double radius = (minRadius + ctx.world().f_46441_.m_188500_() * maxRadius - minRadius) * (double)ctx.modifiers().get(EBItems.BLAST_UPGRADE.get());
            this.teleport(target, ctx.world(), radius);
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ctx.world().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y - 0.5, z, 0.0, 0.0, 0.0);
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.2f, 0.0f, 0.2f).spawn(ctx.world());
    }

    public void teleport(LivingEntity entity, Level world, double radius) {
        float angle = world.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        int x = Mth.m_14107_((double)(entity.m_20185_() + (double)Mth.m_14031_((float)angle) * radius));
        int z = Mth.m_14107_((double)(entity.m_20189_() - (double)Mth.m_14089_((float)angle) * radius));
        Integer y = BlockUtil.getNearestFloor(world, new BlockPos(x, (int)entity.m_20186_(), z), (int)radius);
        if (world.f_46443_) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = entity.m_20185_();
                double dy1 = entity.m_20186_() + (double)(entity.m_20206_() * world.f_46441_.m_188501_());
                double dz1 = entity.m_20189_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, dx1, dy1, dz1, world.f_46441_.m_188500_() - 0.5, world.f_46441_.m_188500_() - 0.5, world.f_46441_.m_188500_() - 0.5);
            }
        }
        if (y != null) {
            if (!world.m_8055_(new BlockPos(x, y.intValue(), z)).m_280555_()) {
                Integer n = y;
                y = y - 1;
            }
            if (world.m_8055_(new BlockPos(x, y + 1, z)).m_280555_() || world.m_8055_(new BlockPos(x, y + 2, z)).m_280555_()) {
                return;
            }
            if (!world.f_46443_) {
                entity.m_6027_((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            this.playSound(world, entity, 0, -1);
        }
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.ATTACK, SpellAction.POINT, 75, 0, 40).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(MINIMUM_TELEPORT).add(MAX_TELEPORT).build();
    }
}

