/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CurseOfEnfeeblement
extends RaySpell {
    public CurseOfEnfeeblement() {
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        LivingEntity target;
        Entity entity = entityHit.m_82443_();
        if (entity instanceof LivingEntity && !MagicDamageSource.isEntityImmune(EBDamageSources.WITHER, (Entity)(target = (LivingEntity)entity))) {
            DamageSource source;
            if (ctx.world().f_46443_) {
                return true;
            }
            target.m_7292_(new MobEffectInstance(EBMobEffects.CURSE_OF_ENFEEBLEMENT.get(), Integer.MAX_VALUE, this.property(DefaultProperties.EFFECT_STRENGTH) * BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"))));
            DamageSource damageSource = source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.WITHER) : target.m_269291_().m_269251_();
            if (target.m_21223_() > target.m_21233_()) {
                target.m_6469_(source, target.m_21223_() - target.m_21233_());
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.2f, 0.0f, 0.3f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().f_46441_.m_188503_(8)).color(0.4f, 0.0f, 0.0f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.NECROMANCY, SpellType.ALTERATION, SpellAction.POINT, 60, 20, 150).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.EFFECT_STRENGTH, 0).build();
    }
}

