/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.data.IStoredSpellVar;
import com.binaris.wizardry.api.content.data.Persistence;
import com.binaris.wizardry.api.content.data.SpellManagerData;
import com.binaris.wizardry.api.content.event.EBLivingHurtEvent;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.api.content.util.NBTExtras;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.core.platform.Services;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBMobEffects;
import com.binaris.wizardry.setup.registries.EBSounds;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CurseOfSoulbinding
extends RaySpell {
    public static final IStoredSpellVar<Set<UUID>> TARGETS_KEY = new IStoredSpellVar.StoredSpellVar<Set, ListTag>("soulboundCreatures", s -> NBTExtras.listToTag(s, NbtUtils::m_129226_), t -> new HashSet<UUID>(NBTExtras.tagToList(t, NbtUtils::m_129233_)), Persistence.DIMENSION_CHANGE);

    public CurseOfSoulbinding() {
        this.soundValues(1.0f, 1.1f, 0.2f);
        Services.OBJECT_DATA.spellStoredVariables(TARGETS_KEY);
    }

    public static Set<UUID> getSoulboundCreatures(SpellManagerData data) {
        if (data.getVariable(TARGETS_KEY) == null) {
            HashSet<UUID> result = new HashSet<UUID>();
            data.setVariable(TARGETS_KEY, result);
            return result;
        }
        return data.getVariable(TARGETS_KEY);
    }

    public static void onLivingHurt(EBLivingHurtEvent event) {
        LivingEntity livingEntity;
        if (!event.getDamagedEntity().m_9236_().f_46443_ && (livingEntity = event.getDamagedEntity()) instanceof Player) {
            Player playerDamaged = (Player)livingEntity;
            SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(playerDamaged);
            Iterator<UUID> iterator = CurseOfSoulbinding.getSoulboundCreatures(data).iterator();
            while (iterator.hasNext()) {
                Entity entity = EntityUtil.getEntityByUUID(playerDamaged.m_9236_(), iterator.next());
                if (entity == null || entity instanceof LivingEntity && !((LivingEntity)entity).m_21023_(EBMobEffects.CURSE_OF_SOULBINDING.get())) {
                    iterator.remove();
                    continue;
                }
                if (!(entity instanceof LivingEntity) || !entity.m_6469_(MagicDamageSource.causeDirectMagicDamage((Entity)playerDamaged, EBDamageSources.SORCERY), event.getAmount())) continue;
                entity.m_5496_(EBSounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE.get(), 1.0f, playerDamaged.m_9236_().f_46441_.m_188501_() * 0.2f + 1.0f);
            }
        }
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        Entity entity = entityHit.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            entity = ctx.caster();
            if (entity instanceof Player) {
                Player caster = (Player)entity;
                SpellManagerData data = Services.OBJECT_DATA.getSpellManagerData(caster);
                if (CurseOfSoulbinding.getSoulboundCreatures(data).add(livingTarget.m_20148_())) {
                    livingTarget.m_7292_(new MobEffectInstance(EBMobEffects.CURSE_OF_SOULBINDING.get(), Integer.MAX_VALUE));
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.4f, 0.0f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).time(12 + ctx.world().f_46441_.m_188503_(8)).color(1.0f, 0.8f, 1.0f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.ALTERATION, SpellAction.POINT, 35, 10, 100).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

