/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.entity.construct.BubbleConstruct;
import com.binaris.wizardry.content.entity.living.AbstractWizard;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Entrapment
extends RaySpell {
    public static final SpellProperty<Integer> DAMAGE_INTERVAL = SpellProperty.intProperty("damage_interval", 30);

    public Entrapment() {
        this.soundValues(1.0f, 0.85f, 0.3f);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        if (ctx.world().f_46443_) {
            return true;
        }
        Entity entity = entityHit.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        LivingEntity target = (LivingEntity)entity;
        DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.SORCERY) : target.m_269291_().m_269425_();
        target.m_6469_(source, 1.0f);
        if (target instanceof AbstractWizard) {
            ctx.caster().m_213846_((Component)Component.m_237110_((String)"spell.resist", (Object[])new Object[]{target.m_7755_(), this.getDescriptionFormatted()}));
            return true;
        }
        BubbleConstruct bubble = new BubbleConstruct(ctx.world());
        bubble.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        bubble.setCaster(ctx.caster());
        bubble.lifetime = (int)(this.property(DefaultProperties.EFFECT_DURATION).floatValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get()));
        bubble.setDarkOrb(true);
        bubble.damageMultiplier = ctx.modifiers().get("potency");
        ctx.world().m_7967_((Entity)bubble);
        target.m_20329_((Entity)bubble);
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return false;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return true;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        ctx.world().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y - 0.5, z, 0.0, 0.0, 0.0);
        ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.ATTACK, SpellAction.POINT, 35, 10, 75).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.EFFECT_DURATION, 120).add(DAMAGE_INTERVAL).build();
    }
}

