/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.RaySpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LifeDrain
extends RaySpell {
    public LifeDrain() {
        this.particleVelocity(-0.5);
        this.particleSpacing(0.4);
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    @Override
    protected boolean onEntityHit(CastContext ctx, EntityHitResult entityHit, Vec3 origin) {
        LivingEntity target;
        block5: {
            block4: {
                Entity entity = entityHit.m_82443_();
                if (!(entity instanceof LivingEntity)) break block4;
                target = (LivingEntity)entity;
                if (ctx.castingTicks() % 12 == 0) break block5;
            }
            return false;
        }
        float damage = this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency");
        DamageSource source = ctx.caster() != null ? MagicDamageSource.causeDirectMagicDamage((Entity)ctx.caster(), EBDamageSources.SORCERY) : target.m_269291_().m_269425_();
        EntityUtil.attackEntityWithoutKnockback((Entity)target, source, damage);
        if (ctx.caster() != null) {
            ctx.caster().m_5634_(damage * this.property(DefaultProperties.HEALTH).floatValue());
        }
        return true;
    }

    @Override
    protected boolean onMiss(CastContext ctx, Vec3 origin, Vec3 direction) {
        return true;
    }

    @Override
    protected boolean onBlockHit(CastContext ctx, BlockHitResult blockHit, Vec3 origin) {
        return false;
    }

    @Override
    protected void spawnParticle(CastContext ctx, double x, double y, double z, double vx, double vy, double vz) {
        if (ctx.world().f_46441_.m_188503_(5) == 0) {
            ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(x, y, z).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
        }
        ParticleBuilder.create(EBParticles.SPARKLE).pos(x, y, z).velocity(vx, vy, vz).time(8 + ctx.world().f_46441_.m_188503_(6)).color(0.5f, 0.0f, 0.0f).spawn(ctx.world());
    }

    @Override
    public boolean isInstantCast() {
        return false;
    }

    @Override
    protected void playSound(Level world, LivingEntity entity, int castTicks, int duration) {
        this.playSoundLoop(world, entity, castTicks);
    }

    @Override
    protected void playSound(Level world, double x, double y, double z, int ticksInUse, int duration) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.APPRENTICE, Elements.NECROMANCY, SpellType.ATTACK, SpellAction.POINT, 10, 0, 0).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).add(DefaultProperties.DAMAGE, Float.valueOf(2.0f)).add(DefaultProperties.HEALTH, Float.valueOf(0.35f)).build();
    }
}

