/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.client.ParticleBuilder;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.MagicDamageSource;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.AreaEffectSpell;
import com.binaris.wizardry.content.spell.abstr.BuffSpell;
import com.binaris.wizardry.setup.registries.EBDamageSources;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import com.binaris.wizardry.setup.registries.client.EBParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PlagueOfDarkness
extends AreaEffectSpell {
    public PlagueOfDarkness() {
        this.alwaysSucceed(true);
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    protected boolean affectEntity(CastContext ctx, Vec3 origin, LivingEntity target, int targetCount) {
        if (!MagicDamageSource.isEntityImmune(EBDamageSources.WITHER, (Entity)target)) {
            if (ctx.world().f_46443_) {
                return true;
            }
            target.m_6469_(target.m_269291_().m_269251_(), this.property(DefaultProperties.DAMAGE).floatValue() * ctx.modifiers().get("potency"));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, (int)((float)this.property(DefaultProperties.EFFECT_DURATION).intValue() * ctx.modifiers().get(EBItems.DURATION_UPGRADE.get())), this.property(DefaultProperties.EFFECT_STRENGTH) + BuffSpell.getStandardBonusAmplifier(ctx.modifiers().get("potency"))));
        }
        return true;
    }

    @Override
    protected void spawnParticleEffect(CastContext ctx, Vec3 origin, double radius) {
        for (int i = 0; i < 40; ++i) {
            double particleX = origin.f_82479_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            double particleZ = origin.f_82481_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            ParticleBuilder.create(EBParticles.DARK_MAGIC).pos(particleX, origin.f_82480_, particleZ).velocity(particleX - origin.f_82479_, 0.0, particleZ - origin.f_82481_).color(0.1f, 0.0f, 0.0f).spawn(ctx.world());
            particleX = origin.f_82479_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            particleZ = origin.f_82481_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            ParticleBuilder.create(EBParticles.SPARKLE).pos(particleX, origin.f_82480_, particleZ).velocity(particleX - origin.f_82479_, 0.0, particleZ - origin.f_82481_).time(30).color(0.1f, 0.0f, 0.05f).spawn(ctx.world());
            particleX = origin.f_82479_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            particleZ = origin.f_82481_ - 1.0 + 2.0 * ctx.world().f_46441_.m_188500_();
            BlockState state = ctx.world().m_8055_(new BlockPos((int)origin.f_82479_, (int)(origin.f_82480_ - 0.5), (int)origin.f_82481_));
            if (state.m_60799_() == RenderShape.INVISIBLE) continue;
            ctx.world().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), particleX, origin.f_82480_, particleZ, particleX - origin.f_82479_, 0.0, particleZ - origin.f_82481_);
        }
        ParticleBuilder.create(EBParticles.SPHERE).pos(origin.m_82520_(0.0, 0.1, 0.0)).scale((float)radius * 0.8f).color(0.8f, 0.0f, 0.05f).spawn(ctx.world());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.NECROMANCY, SpellType.ATTACK, SpellAction.POINT_DOWN, 75, 15, 200).add(DefaultProperties.EFFECT_RADIUS, 5).add(DefaultProperties.DAMAGE, Float.valueOf(8.0f)).add(DefaultProperties.EFFECT_DURATION, 140).add(DefaultProperties.EFFECT_STRENGTH, 2).build();
    }
}

