/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.content.spell.Spell;
import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.EntityCastContext;
import com.binaris.wizardry.api.content.spell.internal.PlayerCastContext;
import com.binaris.wizardry.api.content.spell.internal.SpellModifiers;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.util.EntityUtil;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShulkerBullet
extends Spell {
    @Override
    public boolean cast(PlayerCastContext ctx) {
        return this.shoot(ctx.world(), (LivingEntity)ctx.caster(), ctx.caster().m_20185_(), ctx.caster().m_20186_(), ctx.caster().m_20189_(), ctx.castingTicks(), ctx.modifiers());
    }

    @Override
    public boolean cast(EntityCastContext ctx) {
        return this.shoot(ctx.world(), ctx.caster(), ctx.caster().m_20185_(), ctx.caster().m_20186_(), ctx.caster().m_20189_(), ctx.castingTicks(), ctx.modifiers());
    }

    private boolean shoot(Level world, LivingEntity caster, double x, double y, double z, int castingTicks, SpellModifiers modifiers) {
        if (!world.f_46443_) {
            double range = this.property(DefaultProperties.RANGE).floatValue() * modifiers.get(EBItems.RANGE_UPGRADE.get());
            List<LivingEntity> possibleTargets = EntityUtil.getLivingWithinRadius(range, x, y, z, world);
            possibleTargets.remove(caster);
            possibleTargets.removeIf(t -> t instanceof ArmorStand);
            if (possibleTargets.isEmpty()) {
                return false;
            }
            possibleTargets.sort(Comparator.comparingDouble(t -> t.m_20275_(x, y, z)));
            Entity target = (Entity)possibleTargets.get(0);
            world.m_7967_((Entity)new net.minecraft.world.entity.projectile.ShulkerBullet(world, caster, target, Direction.UP.m_122434_()));
            this.playSound(world, caster, castingTicks, -1);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.ADVANCED, Elements.NECROMANCY, SpellType.PROJECTILE, SpellAction.POINT_DOWN, 25, 0, 40).add(DefaultProperties.RANGE, Float.valueOf(10.0f)).build();
    }
}

