/*
 * Decompiled with CFR 0.152.
 */
package com.binaris.wizardry.content.spell.necromancy;

import com.binaris.wizardry.api.content.spell.SpellAction;
import com.binaris.wizardry.api.content.spell.SpellType;
import com.binaris.wizardry.api.content.spell.internal.CastContext;
import com.binaris.wizardry.api.content.spell.properties.SpellProperties;
import com.binaris.wizardry.api.content.spell.properties.SpellProperty;
import com.binaris.wizardry.api.content.util.BlockUtil;
import com.binaris.wizardry.content.entity.construct.ZombieSpawnerConstruct;
import com.binaris.wizardry.content.spell.DefaultProperties;
import com.binaris.wizardry.content.spell.abstr.ConstructSpell;
import com.binaris.wizardry.core.integrations.accessories.EBAccessoriesIntegration;
import com.binaris.wizardry.setup.registries.EBItems;
import com.binaris.wizardry.setup.registries.Elements;
import com.binaris.wizardry.setup.registries.SpellTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZombieApocalypse
extends ConstructSpell<ZombieSpawnerConstruct> {
    public static final SpellProperty<Integer> MINION_SPAWN_INTERVAL = SpellProperty.intProperty("minion_spawn_interval", 20);
    private static final int SPAWNER_HEIGHT = 8;
    private static final int MIN_SPAWNER_HEIGHT = 3;

    public ZombieApocalypse() {
        super(ZombieSpawnerConstruct::new, false);
        this.soundValues(1.3f, 1.0f, 0.0f);
    }

    @Override
    protected boolean spawnConstruct(CastContext ctx, Vec3 vec3, @Nullable Direction side) {
        Integer ceiling = BlockUtil.getNearestSurface(ctx.world(), new BlockPos((int)vec3.f_82479_, (int)(vec3.f_82480_ + 3.0), (int)vec3.f_82481_), Direction.UP, 5, false, BlockUtil.SurfaceCriteria.COLLIDABLE.flip());
        vec3 = ceiling == null ? vec3.m_82520_(0.0, 8.0, 0.0) : new Vec3(vec3.f_82479_, (double)ceiling.intValue() - 0.5, vec3.f_82481_);
        return super.spawnConstruct(ctx, vec3, side);
    }

    @Override
    protected void addConstructExtras(ZombieSpawnerConstruct construct, Direction side, @Nullable LivingEntity caster) {
        construct.spawnHusks = caster instanceof Player && EBAccessoriesIntegration.isEquipped((Player)caster, EBItems.CHARM_MINION_VARIANTS.get());
    }

    @Override
    @NotNull
    protected SpellProperties properties() {
        return SpellProperties.builder().assignBaseProperties(SpellTiers.MASTER, Elements.NECROMANCY, SpellType.CONSTRUCT, SpellAction.SUMMON, 150, 25, 300).add(DefaultProperties.DURATION, 500).add(DefaultProperties.MINION_LIFETIME, 600).add(MINION_SPAWN_INTERVAL).build();
    }
}

